/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <gtest/gtest.h>

#include "NeuralNetworks.h"

namespace {

class ValidateModelTest : public ::testing::Test {
   protected:
    virtual void SetUp() {}
};

TEST_F(ValidateModelTest, MaskRCNN2Go) {
    ANeuralNetworksModel* model = nullptr;
    ASSERT_EQ(ANeuralNetworksModel_create(&model), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_0{};
    operand_0.type = ANEURALNETWORKS_BOOL;
    operand_0.scale = 0;
    operand_0.zeroPoint = 0;
    operand_0.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_0), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_1{};
    operand_1.type = ANEURALNETWORKS_BOOL;
    operand_1.scale = 0;
    operand_1.zeroPoint = 0;
    operand_1.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_1), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_2{};
    operand_2.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    operand_2.scale = 0;
    operand_2.zeroPoint = 0;
    operand_2.dimensionCount = 4;
    const uint32_t dimensions_2[] = {1, 3, 0, 0};
    operand_2.dimensions = dimensions_2;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_2), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_3{};
    operand_3.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    operand_3.scale = 0;
    operand_3.zeroPoint = 0;
    operand_3.dimensionCount = 2;
    const uint32_t dimensions_3[] = {1, 3};
    operand_3.dimensions = dimensions_3;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_3), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_4{};
    operand_4.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    operand_4.scale = 0;
    operand_4.zeroPoint = 0;
    operand_4.dimensionCount = 2;
    const uint32_t dimensions_4[] = {1, 2};
    operand_4.dimensions = dimensions_4;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_4), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_5{};
    operand_5.type = ANEURALNETWORKS_TENSOR_QUANT16_ASYMM;
    operand_5.scale = 0.125;
    operand_5.zeroPoint = 0;
    operand_5.dimensionCount = 2;
    const uint32_t dimensions_5[] = {1, 2};
    operand_5.dimensions = dimensions_5;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_5), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_6{};
    operand_6.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_6.scale = 0;
    operand_6.zeroPoint = 0;
    operand_6.dimensionCount = 1;
    const uint32_t dimensions_6[] = {4};
    operand_6.dimensions = dimensions_6;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_6), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_7{};
    operand_7.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    operand_7.scale = 0;
    operand_7.zeroPoint = 0;
    operand_7.dimensionCount = 4;
    const uint32_t dimensions_7[] = {1, 0, 0, 3};
    operand_7.dimensions = dimensions_7;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_7), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_8{};
    operand_8.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_8.scale = 0.9891946315765381;
    operand_8.zeroPoint = 0;
    operand_8.dimensionCount = 4;
    const uint32_t dimensions_8[] = {1, 0, 0, 3};
    operand_8.dimensions = dimensions_8;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_8), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_9{};
    operand_9.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_9.scale = 5.880743992747739e-05;
    operand_9.zeroPoint = 95;
    operand_9.dimensionCount = 4;
    const uint32_t dimensions_9[] = {16, 3, 3, 3};
    operand_9.dimensions = dimensions_9;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_9), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_10{};
    operand_10.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_10.scale = 5.81720050831791e-05;
    operand_10.zeroPoint = 0;
    operand_10.dimensionCount = 1;
    const uint32_t dimensions_10[] = {16};
    operand_10.dimensions = dimensions_10;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_10), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_11{};
    operand_11.type = ANEURALNETWORKS_INT32;
    operand_11.scale = 0;
    operand_11.zeroPoint = 0;
    operand_11.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_11), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_12{};
    operand_12.type = ANEURALNETWORKS_INT32;
    operand_12.scale = 0;
    operand_12.zeroPoint = 0;
    operand_12.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_12), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_13{};
    operand_13.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_13.scale = 0.01966476067900658;
    operand_13.zeroPoint = 0;
    operand_13.dimensionCount = 4;
    const uint32_t dimensions_13[] = {1, 0, 0, 16};
    operand_13.dimensions = dimensions_13;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_13), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_14{};
    operand_14.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_14.scale = 0.01236020401120186;
    operand_14.zeroPoint = 94;
    operand_14.dimensionCount = 4;
    const uint32_t dimensions_14[] = {16, 1, 1, 16};
    operand_14.dimensions = dimensions_14;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_14), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_15{};
    operand_15.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_15.scale = 0.0002430604654364288;
    operand_15.zeroPoint = 0;
    operand_15.dimensionCount = 1;
    const uint32_t dimensions_15[] = {16};
    operand_15.dimensions = dimensions_15;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_15), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_16{};
    operand_16.type = ANEURALNETWORKS_INT32;
    operand_16.scale = 0;
    operand_16.zeroPoint = 0;
    operand_16.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_16), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_17{};
    operand_17.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_17.scale = 0.01199939660727978;
    operand_17.zeroPoint = 0;
    operand_17.dimensionCount = 4;
    const uint32_t dimensions_17[] = {1, 0, 0, 16};
    operand_17.dimensions = dimensions_17;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_17), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_18{};
    operand_18.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_18.scale = 0.006678132340312004;
    operand_18.zeroPoint = 124;
    operand_18.dimensionCount = 4;
    const uint32_t dimensions_18[] = {1, 3, 3, 16};
    operand_18.dimensions = dimensions_18;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_18), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_19{};
    operand_19.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_19.scale = 8.013355545699596e-05;
    operand_19.zeroPoint = 0;
    operand_19.dimensionCount = 1;
    const uint32_t dimensions_19[] = {16};
    operand_19.dimensions = dimensions_19;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_19), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_20{};
    operand_20.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_20.scale = 0.01280416082590818;
    operand_20.zeroPoint = 136;
    operand_20.dimensionCount = 4;
    const uint32_t dimensions_20[] = {1, 0, 0, 16};
    operand_20.dimensions = dimensions_20;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_20), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_21{};
    operand_21.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_21.scale = 0.02433430217206478;
    operand_21.zeroPoint = 111;
    operand_21.dimensionCount = 4;
    const uint32_t dimensions_21[] = {16, 1, 1, 16};
    operand_21.dimensions = dimensions_21;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_21), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_22{};
    operand_22.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_22.scale = 0.0003115803119726479;
    operand_22.zeroPoint = 0;
    operand_22.dimensionCount = 1;
    const uint32_t dimensions_22[] = {16};
    operand_22.dimensions = dimensions_22;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_22), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_23{};
    operand_23.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_23.scale = 0.04481548070907593;
    operand_23.zeroPoint = 132;
    operand_23.dimensionCount = 4;
    const uint32_t dimensions_23[] = {1, 0, 0, 16};
    operand_23.dimensions = dimensions_23;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_23), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_24{};
    operand_24.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_24.scale = 0.04634242877364159;
    operand_24.zeroPoint = 128;
    operand_24.dimensionCount = 4;
    const uint32_t dimensions_24[] = {1, 0, 0, 16};
    operand_24.dimensions = dimensions_24;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_24), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_25{};
    operand_25.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_25.scale = 0.005194671452045441;
    operand_25.zeroPoint = 158;
    operand_25.dimensionCount = 4;
    const uint32_t dimensions_25[] = {96, 1, 1, 16};
    operand_25.dimensions = dimensions_25;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_25), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_26{};
    operand_26.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_26.scale = 0.0002407336869509891;
    operand_26.zeroPoint = 0;
    operand_26.dimensionCount = 1;
    const uint32_t dimensions_26[] = {96};
    operand_26.dimensions = dimensions_26;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_26), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_27{};
    operand_27.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_27.scale = 0.01568881794810295;
    operand_27.zeroPoint = 0;
    operand_27.dimensionCount = 4;
    const uint32_t dimensions_27[] = {1, 0, 0, 96};
    operand_27.dimensions = dimensions_27;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_27), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_28{};
    operand_28.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_28.scale = 0.001355677493847907;
    operand_28.zeroPoint = 127;
    operand_28.dimensionCount = 4;
    const uint32_t dimensions_28[] = {1, 3, 3, 96};
    operand_28.dimensions = dimensions_28;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_28), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_29{};
    operand_29.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_29.scale = 2.126897743437439e-05;
    operand_29.zeroPoint = 0;
    operand_29.dimensionCount = 1;
    const uint32_t dimensions_29[] = {96};
    operand_29.dimensions = dimensions_29;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_29), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_30{};
    operand_30.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_30.scale = 0.01245978008955717;
    operand_30.zeroPoint = 123;
    operand_30.dimensionCount = 4;
    const uint32_t dimensions_30[] = {1, 0, 0, 96};
    operand_30.dimensions = dimensions_30;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_30), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_31{};
    operand_31.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_31.scale = 0.01157373003661633;
    operand_31.zeroPoint = 134;
    operand_31.dimensionCount = 4;
    const uint32_t dimensions_31[] = {32, 1, 1, 96};
    operand_31.dimensions = dimensions_31;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_31), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_32{};
    operand_32.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_32.scale = 0.000144206132972613;
    operand_32.zeroPoint = 0;
    operand_32.dimensionCount = 1;
    const uint32_t dimensions_32[] = {32};
    operand_32.dimensions = dimensions_32;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_32), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_33{};
    operand_33.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_33.scale = 0.01940538175404072;
    operand_33.zeroPoint = 135;
    operand_33.dimensionCount = 4;
    const uint32_t dimensions_33[] = {1, 0, 0, 32};
    operand_33.dimensions = dimensions_33;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_33), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_34{};
    operand_34.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_34.scale = 0.003280390985310078;
    operand_34.zeroPoint = 129;
    operand_34.dimensionCount = 4;
    const uint32_t dimensions_34[] = {192, 1, 1, 32};
    operand_34.dimensions = dimensions_34;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_34), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_35{};
    operand_35.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_35.scale = 6.365723675116897e-05;
    operand_35.zeroPoint = 0;
    operand_35.dimensionCount = 1;
    const uint32_t dimensions_35[] = {192};
    operand_35.dimensions = dimensions_35;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_35), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_36{};
    operand_36.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_36.scale = 0.005680288188159466;
    operand_36.zeroPoint = 0;
    operand_36.dimensionCount = 4;
    const uint32_t dimensions_36[] = {1, 0, 0, 192};
    operand_36.dimensions = dimensions_36;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_36), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_37{};
    operand_37.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_37.scale = 0.002816423308104277;
    operand_37.zeroPoint = 131;
    operand_37.dimensionCount = 4;
    const uint32_t dimensions_37[] = {1, 3, 3, 192};
    operand_37.dimensions = dimensions_37;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_37), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_38{};
    operand_38.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_38.scale = 1.599809547769837e-05;
    operand_38.zeroPoint = 0;
    operand_38.dimensionCount = 1;
    const uint32_t dimensions_38[] = {192};
    operand_38.dimensions = dimensions_38;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_38), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_39{};
    operand_39.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_39.scale = 0.002300027292221785;
    operand_39.zeroPoint = 111;
    operand_39.dimensionCount = 4;
    const uint32_t dimensions_39[] = {1, 0, 0, 192};
    operand_39.dimensions = dimensions_39;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_39), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_40{};
    operand_40.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_40.scale = 0.02601869031786919;
    operand_40.zeroPoint = 133;
    operand_40.dimensionCount = 4;
    const uint32_t dimensions_40[] = {32, 1, 1, 192};
    operand_40.dimensions = dimensions_40;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_40), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_41{};
    operand_41.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_41.scale = 5.984370000078343e-05;
    operand_41.zeroPoint = 0;
    operand_41.dimensionCount = 1;
    const uint32_t dimensions_41[] = {32};
    operand_41.dimensions = dimensions_41;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_41), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_42{};
    operand_42.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_42.scale = 0.01957281865179539;
    operand_42.zeroPoint = 126;
    operand_42.dimensionCount = 4;
    const uint32_t dimensions_42[] = {1, 0, 0, 32};
    operand_42.dimensions = dimensions_42;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_42), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_43{};
    operand_43.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_43.scale = 0.028990238904953;
    operand_43.zeroPoint = 123;
    operand_43.dimensionCount = 4;
    const uint32_t dimensions_43[] = {1, 0, 0, 32};
    operand_43.dimensions = dimensions_43;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_43), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_44{};
    operand_44.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_44.scale = 0.002658893587067723;
    operand_44.zeroPoint = 135;
    operand_44.dimensionCount = 4;
    const uint32_t dimensions_44[] = {192, 1, 1, 32};
    operand_44.dimensions = dimensions_44;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_44), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_45{};
    operand_45.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_45.scale = 7.708196062594652e-05;
    operand_45.zeroPoint = 0;
    operand_45.dimensionCount = 1;
    const uint32_t dimensions_45[] = {192};
    operand_45.dimensions = dimensions_45;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_45), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_46{};
    operand_46.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_46.scale = 0.009067215956747532;
    operand_46.zeroPoint = 0;
    operand_46.dimensionCount = 4;
    const uint32_t dimensions_46[] = {1, 0, 0, 192};
    operand_46.dimensions = dimensions_46;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_46), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_47{};
    operand_47.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_47.scale = 0.001217219163663685;
    operand_47.zeroPoint = 125;
    operand_47.dimensionCount = 4;
    const uint32_t dimensions_47[] = {1, 3, 3, 192};
    operand_47.dimensions = dimensions_47;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_47), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_48{};
    operand_48.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_48.scale = 1.103678914660122e-05;
    operand_48.zeroPoint = 0;
    operand_48.dimensionCount = 1;
    const uint32_t dimensions_48[] = {192};
    operand_48.dimensions = dimensions_48;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_48), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_49{};
    operand_49.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_49.scale = 0.003552014008164406;
    operand_49.zeroPoint = 130;
    operand_49.dimensionCount = 4;
    const uint32_t dimensions_49[] = {1, 0, 0, 192};
    operand_49.dimensions = dimensions_49;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_49), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_50{};
    operand_50.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_50.scale = 0.01093960553407669;
    operand_50.zeroPoint = 125;
    operand_50.dimensionCount = 4;
    const uint32_t dimensions_50[] = {48, 1, 1, 192};
    operand_50.dimensions = dimensions_50;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_50), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_51{};
    operand_51.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_51.scale = 3.885763362632133e-05;
    operand_51.zeroPoint = 0;
    operand_51.dimensionCount = 1;
    const uint32_t dimensions_51[] = {48};
    operand_51.dimensions = dimensions_51;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_51), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_52{};
    operand_52.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_52.scale = 0.01332638971507549;
    operand_52.zeroPoint = 115;
    operand_52.dimensionCount = 4;
    const uint32_t dimensions_52[] = {1, 0, 0, 48};
    operand_52.dimensions = dimensions_52;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_52), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_53{};
    operand_53.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_53.scale = 0.003872227622196078;
    operand_53.zeroPoint = 110;
    operand_53.dimensionCount = 4;
    const uint32_t dimensions_53[] = {288, 1, 1, 48};
    operand_53.dimensions = dimensions_53;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_53), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_54{};
    operand_54.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_54.scale = 5.160281580174342e-05;
    operand_54.zeroPoint = 0;
    operand_54.dimensionCount = 1;
    const uint32_t dimensions_54[] = {288};
    operand_54.dimensions = dimensions_54;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_54), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_55{};
    operand_55.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_55.scale = 0.005248025059700012;
    operand_55.zeroPoint = 0;
    operand_55.dimensionCount = 4;
    const uint32_t dimensions_55[] = {1, 0, 0, 288};
    operand_55.dimensions = dimensions_55;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_55), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_56{};
    operand_56.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_56.scale = 0.001976602710783482;
    operand_56.zeroPoint = 121;
    operand_56.dimensionCount = 4;
    const uint32_t dimensions_56[] = {1, 3, 3, 288};
    operand_56.dimensions = dimensions_56;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_56), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_57{};
    operand_57.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_57.scale = 1.037326001096517e-05;
    operand_57.zeroPoint = 0;
    operand_57.dimensionCount = 1;
    const uint32_t dimensions_57[] = {288};
    operand_57.dimensions = dimensions_57;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_57), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_58{};
    operand_58.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_58.scale = 0.001622712821699679;
    operand_58.zeroPoint = 128;
    operand_58.dimensionCount = 4;
    const uint32_t dimensions_58[] = {1, 0, 0, 288};
    operand_58.dimensions = dimensions_58;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_58), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_59{};
    operand_59.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_59.scale = 0.01881795562803745;
    operand_59.zeroPoint = 132;
    operand_59.dimensionCount = 4;
    const uint32_t dimensions_59[] = {48, 1, 1, 288};
    operand_59.dimensions = dimensions_59;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_59), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_60{};
    operand_60.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_60.scale = 3.053613909287378e-05;
    operand_60.zeroPoint = 0;
    operand_60.dimensionCount = 1;
    const uint32_t dimensions_60[] = {48};
    operand_60.dimensions = dimensions_60;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_60), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_61{};
    operand_61.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_61.scale = 0.01099279243499041;
    operand_61.zeroPoint = 126;
    operand_61.dimensionCount = 4;
    const uint32_t dimensions_61[] = {1, 0, 0, 48};
    operand_61.dimensions = dimensions_61;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_61), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_62{};
    operand_62.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_62.scale = 0.01927739381790161;
    operand_62.zeroPoint = 118;
    operand_62.dimensionCount = 4;
    const uint32_t dimensions_62[] = {1, 0, 0, 48};
    operand_62.dimensions = dimensions_62;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_62), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_63{};
    operand_63.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_63.scale = 0.00215660990215838;
    operand_63.zeroPoint = 111;
    operand_63.dimensionCount = 4;
    const uint32_t dimensions_63[] = {288, 1, 1, 48};
    operand_63.dimensions = dimensions_63;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_63), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_64{};
    operand_64.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_64.scale = 4.157381772529334e-05;
    operand_64.zeroPoint = 0;
    operand_64.dimensionCount = 1;
    const uint32_t dimensions_64[] = {288};
    operand_64.dimensions = dimensions_64;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_64), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_65{};
    operand_65.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_65.scale = 0.004311998840421438;
    operand_65.zeroPoint = 0;
    operand_65.dimensionCount = 4;
    const uint32_t dimensions_65[] = {1, 0, 0, 288};
    operand_65.dimensions = dimensions_65;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_65), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_66{};
    operand_66.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_66.scale = 0.001798613811843097;
    operand_66.zeroPoint = 128;
    operand_66.dimensionCount = 4;
    const uint32_t dimensions_66[] = {1, 3, 3, 288};
    operand_66.dimensions = dimensions_66;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_66), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_67{};
    operand_67.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_67.scale = 7.755620572424959e-06;
    operand_67.zeroPoint = 0;
    operand_67.dimensionCount = 1;
    const uint32_t dimensions_67[] = {288};
    operand_67.dimensions = dimensions_67;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_67), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_68{};
    operand_68.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_68.scale = 0.001595283509232104;
    operand_68.zeroPoint = 122;
    operand_68.dimensionCount = 4;
    const uint32_t dimensions_68[] = {1, 0, 0, 288};
    operand_68.dimensions = dimensions_68;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_68), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_69{};
    operand_69.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_69.scale = 0.02731921337544918;
    operand_69.zeroPoint = 136;
    operand_69.dimensionCount = 4;
    const uint32_t dimensions_69[] = {48, 1, 1, 288};
    operand_69.dimensions = dimensions_69;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_69), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_70{};
    operand_70.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_70.scale = 4.358188743935898e-05;
    operand_70.zeroPoint = 0;
    operand_70.dimensionCount = 1;
    const uint32_t dimensions_70[] = {48};
    operand_70.dimensions = dimensions_70;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_70), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_71{};
    operand_71.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_71.scale = 0.01208362448960543;
    operand_71.zeroPoint = 120;
    operand_71.dimensionCount = 4;
    const uint32_t dimensions_71[] = {1, 0, 0, 48};
    operand_71.dimensions = dimensions_71;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_71), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_72{};
    operand_72.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_72.scale = 0.02560163103044033;
    operand_72.zeroPoint = 107;
    operand_72.dimensionCount = 4;
    const uint32_t dimensions_72[] = {1, 0, 0, 48};
    operand_72.dimensions = dimensions_72;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_72), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_73{};
    operand_73.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_73.scale = 0.003050966653972864;
    operand_73.zeroPoint = 125;
    operand_73.dimensionCount = 4;
    const uint32_t dimensions_73[] = {288, 1, 1, 48};
    operand_73.dimensions = dimensions_73;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_73), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_74{};
    operand_74.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_74.scale = 7.810971874278039e-05;
    operand_74.zeroPoint = 0;
    operand_74.dimensionCount = 1;
    const uint32_t dimensions_74[] = {288};
    operand_74.dimensions = dimensions_74;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_74), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_75{};
    operand_75.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_75.scale = 0.01042873691767454;
    operand_75.zeroPoint = 0;
    operand_75.dimensionCount = 4;
    const uint32_t dimensions_75[] = {1, 0, 0, 288};
    operand_75.dimensions = dimensions_75;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_75), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_76{};
    operand_76.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_76.scale = 0.00121846969705075;
    operand_76.zeroPoint = 117;
    operand_76.dimensionCount = 4;
    const uint32_t dimensions_76[] = {1, 3, 3, 288};
    operand_76.dimensions = dimensions_76;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_76), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_77{};
    operand_77.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_77.scale = 1.270709981326945e-05;
    operand_77.zeroPoint = 0;
    operand_77.dimensionCount = 1;
    const uint32_t dimensions_77[] = {288};
    operand_77.dimensions = dimensions_77;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_77), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_78{};
    operand_78.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_78.scale = 0.002883265493437648;
    operand_78.zeroPoint = 137;
    operand_78.dimensionCount = 4;
    const uint32_t dimensions_78[] = {1, 0, 0, 288};
    operand_78.dimensions = dimensions_78;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_78), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_79{};
    operand_79.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_79.scale = 0.009875123389065266;
    operand_79.zeroPoint = 131;
    operand_79.dimensionCount = 4;
    const uint32_t dimensions_79[] = {96, 1, 1, 288};
    operand_79.dimensions = dimensions_79;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_79), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_80{};
    operand_80.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_80.scale = 2.847260293492582e-05;
    operand_80.zeroPoint = 0;
    operand_80.dimensionCount = 1;
    const uint32_t dimensions_80[] = {96};
    operand_80.dimensions = dimensions_80;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_80), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_81{};
    operand_81.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_81.scale = 0.009474765509366989;
    operand_81.zeroPoint = 115;
    operand_81.dimensionCount = 4;
    const uint32_t dimensions_81[] = {1, 0, 0, 96};
    operand_81.dimensions = dimensions_81;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_81), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_82{};
    operand_82.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_82.scale = 0.00323105463758111;
    operand_82.zeroPoint = 121;
    operand_82.dimensionCount = 4;
    const uint32_t dimensions_82[] = {576, 1, 1, 96};
    operand_82.dimensions = dimensions_82;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_82), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_83{};
    operand_83.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_83.scale = 3.061348616029136e-05;
    operand_83.zeroPoint = 0;
    operand_83.dimensionCount = 1;
    const uint32_t dimensions_83[] = {576};
    operand_83.dimensions = dimensions_83;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_83), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_84{};
    operand_84.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_84.scale = 0.004371246788650751;
    operand_84.zeroPoint = 0;
    operand_84.dimensionCount = 4;
    const uint32_t dimensions_84[] = {1, 0, 0, 576};
    operand_84.dimensions = dimensions_84;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_84), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_85{};
    operand_85.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_85.scale = 0.001316901994869113;
    operand_85.zeroPoint = 132;
    operand_85.dimensionCount = 4;
    const uint32_t dimensions_85[] = {1, 3, 3, 576};
    operand_85.dimensions = dimensions_85;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_85), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_86{};
    operand_86.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_86.scale = 5.75650346945622e-06;
    operand_86.zeroPoint = 0;
    operand_86.dimensionCount = 1;
    const uint32_t dimensions_86[] = {576};
    operand_86.dimensions = dimensions_86;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_86), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_87{};
    operand_87.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_87.scale = 0.001160673331469297;
    operand_87.zeroPoint = 136;
    operand_87.dimensionCount = 4;
    const uint32_t dimensions_87[] = {1, 0, 0, 576};
    operand_87.dimensions = dimensions_87;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_87), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_88{};
    operand_88.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_88.scale = 0.01717966049909592;
    operand_88.zeroPoint = 138;
    operand_88.dimensionCount = 4;
    const uint32_t dimensions_88[] = {96, 1, 1, 576};
    operand_88.dimensions = dimensions_88;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_88), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_89{};
    operand_89.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_89.scale = 1.993997466342989e-05;
    operand_89.zeroPoint = 0;
    operand_89.dimensionCount = 1;
    const uint32_t dimensions_89[] = {96};
    operand_89.dimensions = dimensions_89;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_89), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_90{};
    operand_90.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_90.scale = 0.006981693673878908;
    operand_90.zeroPoint = 120;
    operand_90.dimensionCount = 4;
    const uint32_t dimensions_90[] = {1, 0, 0, 96};
    operand_90.dimensions = dimensions_90;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_90), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_91{};
    operand_91.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_91.scale = 0.01042260229587555;
    operand_91.zeroPoint = 124;
    operand_91.dimensionCount = 4;
    const uint32_t dimensions_91[] = {1, 0, 0, 96};
    operand_91.dimensions = dimensions_91;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_91), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_92{};
    operand_92.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_92.scale = 0.002388325287029147;
    operand_92.zeroPoint = 120;
    operand_92.dimensionCount = 4;
    const uint32_t dimensions_92[] = {576, 1, 1, 96};
    operand_92.dimensions = dimensions_92;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_92), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_93{};
    operand_93.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_93.scale = 2.489256439730525e-05;
    operand_93.zeroPoint = 0;
    operand_93.dimensionCount = 1;
    const uint32_t dimensions_93[] = {576};
    operand_93.dimensions = dimensions_93;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_93), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_94{};
    operand_94.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_94.scale = 0.003468555863946676;
    operand_94.zeroPoint = 0;
    operand_94.dimensionCount = 4;
    const uint32_t dimensions_94[] = {1, 0, 0, 576};
    operand_94.dimensions = dimensions_94;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_94), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_95{};
    operand_95.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_95.scale = 0.001293058856390417;
    operand_95.zeroPoint = 135;
    operand_95.dimensionCount = 4;
    const uint32_t dimensions_95[] = {1, 3, 3, 576};
    operand_95.dimensions = dimensions_95;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_95), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_96{};
    operand_96.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_96.scale = 4.485046702029649e-06;
    operand_96.zeroPoint = 0;
    operand_96.dimensionCount = 1;
    const uint32_t dimensions_96[] = {576};
    operand_96.dimensions = dimensions_96;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_96), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_97{};
    operand_97.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_97.scale = 0.001004486111924052;
    operand_97.zeroPoint = 121;
    operand_97.dimensionCount = 4;
    const uint32_t dimensions_97[] = {1, 0, 0, 576};
    operand_97.dimensions = dimensions_97;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_97), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_98{};
    operand_98.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_98.scale = 0.02229274623095989;
    operand_98.zeroPoint = 132;
    operand_98.dimensionCount = 4;
    const uint32_t dimensions_98[] = {96, 1, 1, 576};
    operand_98.dimensions = dimensions_98;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_98), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_99{};
    operand_99.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_99.scale = 2.239275454485323e-05;
    operand_99.zeroPoint = 0;
    operand_99.dimensionCount = 1;
    const uint32_t dimensions_99[] = {96};
    operand_99.dimensions = dimensions_99;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_99), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_100{};
    operand_100.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_100.scale = 0.00858442485332489;
    operand_100.zeroPoint = 128;
    operand_100.dimensionCount = 4;
    const uint32_t dimensions_100[] = {1, 0, 0, 96};
    operand_100.dimensions = dimensions_100;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_100), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_101{};
    operand_101.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_101.scale = 0.01262346189469099;
    operand_101.zeroPoint = 130;
    operand_101.dimensionCount = 4;
    const uint32_t dimensions_101[] = {1, 0, 0, 96};
    operand_101.dimensions = dimensions_101;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_101), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_102{};
    operand_102.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_102.scale = 0.001790200243704021;
    operand_102.zeroPoint = 143;
    operand_102.dimensionCount = 4;
    const uint32_t dimensions_102[] = {576, 1, 1, 96};
    operand_102.dimensions = dimensions_102;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_102), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_103{};
    operand_103.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_103.scale = 2.259852408315055e-05;
    operand_103.zeroPoint = 0;
    operand_103.dimensionCount = 1;
    const uint32_t dimensions_103[] = {576};
    operand_103.dimensions = dimensions_103;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_103), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_104{};
    operand_104.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_104.scale = 0.003789969952777028;
    operand_104.zeroPoint = 0;
    operand_104.dimensionCount = 4;
    const uint32_t dimensions_104[] = {1, 0, 0, 576};
    operand_104.dimensions = dimensions_104;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_104), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_105{};
    operand_105.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_105.scale = 0.001565286540426314;
    operand_105.zeroPoint = 133;
    operand_105.dimensionCount = 4;
    const uint32_t dimensions_105[] = {1, 3, 3, 576};
    operand_105.dimensions = dimensions_105;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_105), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_106{};
    operand_106.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_106.scale = 5.932388830842683e-06;
    operand_106.zeroPoint = 0;
    operand_106.dimensionCount = 1;
    const uint32_t dimensions_106[] = {576};
    operand_106.dimensions = dimensions_106;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_106), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_107{};
    operand_107.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_107.scale = 0.001188441878184676;
    operand_107.zeroPoint = 107;
    operand_107.dimensionCount = 4;
    const uint32_t dimensions_107[] = {1, 0, 0, 576};
    operand_107.dimensions = dimensions_107;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_107), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_108{};
    operand_108.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_108.scale = 0.03223617374897003;
    operand_108.zeroPoint = 131;
    operand_108.dimensionCount = 4;
    const uint32_t dimensions_108[] = {96, 1, 1, 576};
    operand_108.dimensions = dimensions_108;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_108), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_109{};
    operand_109.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_109.scale = 3.83108199457638e-05;
    operand_109.zeroPoint = 0;
    operand_109.dimensionCount = 1;
    const uint32_t dimensions_109[] = {96};
    operand_109.dimensions = dimensions_109;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_109), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_110{};
    operand_110.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_110.scale = 0.01084044575691223;
    operand_110.zeroPoint = 130;
    operand_110.dimensionCount = 4;
    const uint32_t dimensions_110[] = {1, 0, 0, 96};
    operand_110.dimensions = dimensions_110;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_110), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_111{};
    operand_111.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_111.scale = 0.01627451553940773;
    operand_111.zeroPoint = 133;
    operand_111.dimensionCount = 4;
    const uint32_t dimensions_111[] = {1, 0, 0, 96};
    operand_111.dimensions = dimensions_111;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_111), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_112{};
    operand_112.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_112.scale = 0.001678385655395687;
    operand_112.zeroPoint = 135;
    operand_112.dimensionCount = 4;
    const uint32_t dimensions_112[] = {576, 1, 1, 96};
    operand_112.dimensions = dimensions_112;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_112), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_113{};
    operand_113.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_113.scale = 2.731491440499667e-05;
    operand_113.zeroPoint = 0;
    operand_113.dimensionCount = 1;
    const uint32_t dimensions_113[] = {576};
    operand_113.dimensions = dimensions_113;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_113), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_114{};
    operand_114.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_114.scale = 0.004788670688867569;
    operand_114.zeroPoint = 0;
    operand_114.dimensionCount = 4;
    const uint32_t dimensions_114[] = {1, 0, 0, 576};
    operand_114.dimensions = dimensions_114;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_114), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_115{};
    operand_115.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_115.scale = 0.001882086275145411;
    operand_115.zeroPoint = 130;
    operand_115.dimensionCount = 4;
    const uint32_t dimensions_115[] = {1, 3, 3, 576};
    operand_115.dimensions = dimensions_115;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_115), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_116{};
    operand_116.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_116.scale = 9.012691407406237e-06;
    operand_116.zeroPoint = 0;
    operand_116.dimensionCount = 1;
    const uint32_t dimensions_116[] = {576};
    operand_116.dimensions = dimensions_116;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_116), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_117{};
    operand_117.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_117.scale = 0.001888960134238005;
    operand_117.zeroPoint = 131;
    operand_117.dimensionCount = 4;
    const uint32_t dimensions_117[] = {1, 0, 0, 576};
    operand_117.dimensions = dimensions_117;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_117), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_118{};
    operand_118.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_118.scale = 0.006059954408556223;
    operand_118.zeroPoint = 131;
    operand_118.dimensionCount = 4;
    const uint32_t dimensions_118[] = {128, 1, 1, 576};
    operand_118.dimensions = dimensions_118;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_118), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_119{};
    operand_119.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_119.scale = 1.144701218436239e-05;
    operand_119.zeroPoint = 0;
    operand_119.dimensionCount = 1;
    const uint32_t dimensions_119[] = {128};
    operand_119.dimensions = dimensions_119;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_119), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_120{};
    operand_120.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_120.scale = 0.004614091943949461;
    operand_120.zeroPoint = 131;
    operand_120.dimensionCount = 4;
    const uint32_t dimensions_120[] = {1, 0, 0, 128};
    operand_120.dimensions = dimensions_120;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_120), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_121{};
    operand_121.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_121.scale = 0.007414539344608784;
    operand_121.zeroPoint = 126;
    operand_121.dimensionCount = 4;
    const uint32_t dimensions_121[] = {768, 1, 1, 128};
    operand_121.dimensions = dimensions_121;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_121), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_122{};
    operand_122.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_122.scale = 3.42113635269925e-05;
    operand_122.zeroPoint = 0;
    operand_122.dimensionCount = 1;
    const uint32_t dimensions_122[] = {768};
    operand_122.dimensions = dimensions_122;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_122), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_123{};
    operand_123.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_123.scale = 0.002970855450257659;
    operand_123.zeroPoint = 0;
    operand_123.dimensionCount = 4;
    const uint32_t dimensions_123[] = {1, 0, 0, 768};
    operand_123.dimensions = dimensions_123;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_123), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_124{};
    operand_124.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_124.scale = 0.00154426705557853;
    operand_124.zeroPoint = 127;
    operand_124.dimensionCount = 4;
    const uint32_t dimensions_124[] = {1, 3, 3, 768};
    operand_124.dimensions = dimensions_124;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_124), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_125{};
    operand_125.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_125.scale = 4.58779413747834e-06;
    operand_125.zeroPoint = 0;
    operand_125.dimensionCount = 1;
    const uint32_t dimensions_125[] = {768};
    operand_125.dimensions = dimensions_125;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_125), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_126{};
    operand_126.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_126.scale = 0.001004609395749867;
    operand_126.zeroPoint = 119;
    operand_126.dimensionCount = 4;
    const uint32_t dimensions_126[] = {1, 0, 0, 768};
    operand_126.dimensions = dimensions_126;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_126), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_127{};
    operand_127.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_127.scale = 0.01107242610305548;
    operand_127.zeroPoint = 127;
    operand_127.dimensionCount = 4;
    const uint32_t dimensions_127[] = {128, 1, 1, 768};
    operand_127.dimensions = dimensions_127;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_127), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_128{};
    operand_128.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_128.scale = 1.112346308218548e-05;
    operand_128.zeroPoint = 0;
    operand_128.dimensionCount = 1;
    const uint32_t dimensions_128[] = {128};
    operand_128.dimensions = dimensions_128;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_128), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_129{};
    operand_129.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_129.scale = 0.004491065628826618;
    operand_129.zeroPoint = 121;
    operand_129.dimensionCount = 4;
    const uint32_t dimensions_129[] = {1, 0, 0, 128};
    operand_129.dimensions = dimensions_129;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_129), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_130{};
    operand_130.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_130.scale = 0.007918111048638821;
    operand_130.zeroPoint = 132;
    operand_130.dimensionCount = 4;
    const uint32_t dimensions_130[] = {1, 0, 0, 128};
    operand_130.dimensions = dimensions_130;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_130), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_131{};
    operand_131.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_131.scale = 0.004637615289539099;
    operand_131.zeroPoint = 126;
    operand_131.dimensionCount = 4;
    const uint32_t dimensions_131[] = {768, 1, 1, 128};
    operand_131.dimensions = dimensions_131;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_131), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_132{};
    operand_132.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_132.scale = 3.672115417430177e-05;
    operand_132.zeroPoint = 0;
    operand_132.dimensionCount = 1;
    const uint32_t dimensions_132[] = {768};
    operand_132.dimensions = dimensions_132;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_132), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_133{};
    operand_133.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_133.scale = 0.003131674602627754;
    operand_133.zeroPoint = 0;
    operand_133.dimensionCount = 4;
    const uint32_t dimensions_133[] = {1, 0, 0, 768};
    operand_133.dimensions = dimensions_133;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_133), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_134{};
    operand_134.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_134.scale = 0.001537951757200062;
    operand_134.zeroPoint = 130;
    operand_134.dimensionCount = 4;
    const uint32_t dimensions_134[] = {1, 3, 3, 768};
    operand_134.dimensions = dimensions_134;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_134), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_135{};
    operand_135.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_135.scale = 4.816364707949106e-06;
    operand_135.zeroPoint = 0;
    operand_135.dimensionCount = 1;
    const uint32_t dimensions_135[] = {768};
    operand_135.dimensions = dimensions_135;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_135), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_136{};
    operand_136.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_136.scale = 0.001004835939966142;
    operand_136.zeroPoint = 121;
    operand_136.dimensionCount = 4;
    const uint32_t dimensions_136[] = {1, 0, 0, 768};
    operand_136.dimensions = dimensions_136;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_136), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_137{};
    operand_137.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_137.scale = 0.01529518887400627;
    operand_137.zeroPoint = 131;
    operand_137.dimensionCount = 4;
    const uint32_t dimensions_137[] = {128, 1, 1, 768};
    operand_137.dimensions = dimensions_137;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_137), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_138{};
    operand_138.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_138.scale = 1.536915442557074e-05;
    operand_138.zeroPoint = 0;
    operand_138.dimensionCount = 1;
    const uint32_t dimensions_138[] = {128};
    operand_138.dimensions = dimensions_138;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_138), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_139{};
    operand_139.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_139.scale = 0.005413023289293051;
    operand_139.zeroPoint = 121;
    operand_139.dimensionCount = 4;
    const uint32_t dimensions_139[] = {1, 0, 0, 128};
    operand_139.dimensions = dimensions_139;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_139), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_140{};
    operand_140.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_140.scale = 0.01041953638195992;
    operand_140.zeroPoint = 122;
    operand_140.dimensionCount = 4;
    const uint32_t dimensions_140[] = {1, 0, 0, 128};
    operand_140.dimensions = dimensions_140;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_140), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_141{};
    operand_141.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_141.scale = 0.002339381724596024;
    operand_141.zeroPoint = 119;
    operand_141.dimensionCount = 4;
    const uint32_t dimensions_141[] = {768, 1, 1, 128};
    operand_141.dimensions = dimensions_141;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_141), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_142{};
    operand_142.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_142.scale = 2.437527291476727e-05;
    operand_142.zeroPoint = 0;
    operand_142.dimensionCount = 1;
    const uint32_t dimensions_142[] = {768};
    operand_142.dimensions = dimensions_142;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_142), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_143{};
    operand_143.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_143.scale = 0.002237820532172918;
    operand_143.zeroPoint = 0;
    operand_143.dimensionCount = 4;
    const uint32_t dimensions_143[] = {1, 0, 0, 768};
    operand_143.dimensions = dimensions_143;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_143), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_144{};
    operand_144.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_144.scale = 0.0007936766487546265;
    operand_144.zeroPoint = 133;
    operand_144.dimensionCount = 4;
    const uint32_t dimensions_144[] = {1, 3, 3, 768};
    operand_144.dimensions = dimensions_144;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_144), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_145{};
    operand_145.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_145.scale = 1.776105818862561e-06;
    operand_145.zeroPoint = 0;
    operand_145.dimensionCount = 1;
    const uint32_t dimensions_145[] = {768};
    operand_145.dimensions = dimensions_145;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_145), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_146{};
    operand_146.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_146.scale = 0.001001776661723852;
    operand_146.zeroPoint = 115;
    operand_146.dimensionCount = 4;
    const uint32_t dimensions_146[] = {1, 0, 0, 768};
    operand_146.dimensions = dimensions_146;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_146), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_147{};
    operand_147.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_147.scale = 0.02992645651102066;
    operand_147.zeroPoint = 122;
    operand_147.dimensionCount = 4;
    const uint32_t dimensions_147[] = {128, 1, 1, 768};
    operand_147.dimensions = dimensions_147;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_147), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_148{};
    operand_148.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_148.scale = 2.997962474182714e-05;
    operand_148.zeroPoint = 0;
    operand_148.dimensionCount = 1;
    const uint32_t dimensions_148[] = {128};
    operand_148.dimensions = dimensions_148;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_148), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_149{};
    operand_149.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_149.scale = 0.006007113959640265;
    operand_149.zeroPoint = 138;
    operand_149.dimensionCount = 4;
    const uint32_t dimensions_149[] = {1, 0, 0, 128};
    operand_149.dimensions = dimensions_149;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_149), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_150{};
    operand_150.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_150.scale = 0.01333596650511026;
    operand_150.zeroPoint = 128;
    operand_150.dimensionCount = 4;
    const uint32_t dimensions_150[] = {1, 0, 0, 128};
    operand_150.dimensions = dimensions_150;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_150), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_151{};
    operand_151.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_151.scale = 0.002114560455083847;
    operand_151.zeroPoint = 131;
    operand_151.dimensionCount = 4;
    const uint32_t dimensions_151[] = {768, 1, 1, 128};
    operand_151.dimensions = dimensions_151;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_151), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_152{};
    operand_152.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_152.scale = 2.819970904965885e-05;
    operand_152.zeroPoint = 0;
    operand_152.dimensionCount = 1;
    const uint32_t dimensions_152[] = {768};
    operand_152.dimensions = dimensions_152;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_152), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_153{};
    operand_153.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_153.scale = 0.002463524229824543;
    operand_153.zeroPoint = 0;
    operand_153.dimensionCount = 4;
    const uint32_t dimensions_153[] = {1, 0, 0, 768};
    operand_153.dimensions = dimensions_153;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_153), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_154{};
    operand_154.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_154.scale = 0.0009068828076124191;
    operand_154.zeroPoint = 125;
    operand_154.dimensionCount = 4;
    const uint32_t dimensions_154[] = {1, 3, 3, 768};
    operand_154.dimensions = dimensions_154;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_154), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_155{};
    operand_155.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_155.scale = 2.234127578049083e-06;
    operand_155.zeroPoint = 0;
    operand_155.dimensionCount = 1;
    const uint32_t dimensions_155[] = {768};
    operand_155.dimensions = dimensions_155;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_155), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_156{};
    operand_156.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_156.scale = 0.001002233359031379;
    operand_156.zeroPoint = 132;
    operand_156.dimensionCount = 4;
    const uint32_t dimensions_156[] = {1, 0, 0, 768};
    operand_156.dimensions = dimensions_156;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_156), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_157{};
    operand_157.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_157.scale = 0.0339314192533493;
    operand_157.zeroPoint = 113;
    operand_157.dimensionCount = 4;
    const uint32_t dimensions_157[] = {128, 1, 1, 768};
    operand_157.dimensions = dimensions_157;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_157), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_158{};
    operand_158.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_158.scale = 3.400720015633851e-05;
    operand_158.zeroPoint = 0;
    operand_158.dimensionCount = 1;
    const uint32_t dimensions_158[] = {128};
    operand_158.dimensions = dimensions_158;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_158), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_159{};
    operand_159.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_159.scale = 0.007420019246637821;
    operand_159.zeroPoint = 135;
    operand_159.dimensionCount = 4;
    const uint32_t dimensions_159[] = {1, 0, 0, 128};
    operand_159.dimensions = dimensions_159;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_159), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_160{};
    operand_160.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_160.scale = 0.01803975738584995;
    operand_160.zeroPoint = 134;
    operand_160.dimensionCount = 4;
    const uint32_t dimensions_160[] = {1, 0, 0, 128};
    operand_160.dimensions = dimensions_160;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_160), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_161{};
    operand_161.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_161.scale = 0.001758694183081388;
    operand_161.zeroPoint = 134;
    operand_161.dimensionCount = 4;
    const uint32_t dimensions_161[] = {768, 1, 1, 128};
    operand_161.dimensions = dimensions_161;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_161), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_162{};
    operand_162.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_162.scale = 3.172641663695686e-05;
    operand_162.zeroPoint = 0;
    operand_162.dimensionCount = 1;
    const uint32_t dimensions_162[] = {768};
    operand_162.dimensions = dimensions_162;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_162), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_163{};
    operand_163.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_163.scale = 0.003602873533964157;
    operand_163.zeroPoint = 0;
    operand_163.dimensionCount = 4;
    const uint32_t dimensions_163[] = {1, 0, 0, 768};
    operand_163.dimensions = dimensions_163;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_163), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_164{};
    operand_164.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_164.scale = 0.00123634107876569;
    operand_164.zeroPoint = 134;
    operand_164.dimensionCount = 4;
    const uint32_t dimensions_164[] = {1, 3, 3, 768};
    operand_164.dimensions = dimensions_164;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_164), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_165{};
    operand_165.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_165.scale = 4.45438035967527e-06;
    operand_165.zeroPoint = 0;
    operand_165.dimensionCount = 1;
    const uint32_t dimensions_165[] = {768};
    operand_165.dimensions = dimensions_165;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_165), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_166{};
    operand_166.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_166.scale = 0.001004456076771021;
    operand_166.zeroPoint = 114;
    operand_166.dimensionCount = 4;
    const uint32_t dimensions_166[] = {1, 0, 0, 768};
    operand_166.dimensions = dimensions_166;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_166), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_167{};
    operand_167.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_167.scale = 0.04360251501202583;
    operand_167.zeroPoint = 125;
    operand_167.dimensionCount = 4;
    const uint32_t dimensions_167[] = {128, 1, 1, 768};
    operand_167.dimensions = dimensions_167;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_167), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_168{};
    operand_168.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_168.scale = 4.379680831334554e-05;
    operand_168.zeroPoint = 0;
    operand_168.dimensionCount = 1;
    const uint32_t dimensions_168[] = {128};
    operand_168.dimensions = dimensions_168;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_168), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_169{};
    operand_169.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_169.scale = 0.01710499450564384;
    operand_169.zeroPoint = 129;
    operand_169.dimensionCount = 4;
    const uint32_t dimensions_169[] = {1, 0, 0, 128};
    operand_169.dimensions = dimensions_169;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_169), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_170{};
    operand_170.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_170.scale = 0.02661834843456745;
    operand_170.zeroPoint = 134;
    operand_170.dimensionCount = 4;
    const uint32_t dimensions_170[] = {1, 0, 0, 128};
    operand_170.dimensions = dimensions_170;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_170), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_171{};
    operand_171.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_171.scale = 0.003064587479457259;
    operand_171.zeroPoint = 115;
    operand_171.dimensionCount = 4;
    const uint32_t dimensions_171[] = {15, 1, 1, 128};
    operand_171.dimensions = dimensions_171;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_171), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_172{};
    operand_172.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_172.scale = 8.157426054822281e-05;
    operand_172.zeroPoint = 0;
    operand_172.dimensionCount = 1;
    const uint32_t dimensions_172[] = {15};
    operand_172.dimensions = dimensions_172;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_172), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_173{};
    operand_173.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_173.scale = 0.08332997560501099;
    operand_173.zeroPoint = 148;
    operand_173.dimensionCount = 4;
    const uint32_t dimensions_173[] = {1, 0, 0, 15};
    operand_173.dimensions = dimensions_173;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_173), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_174{};
    operand_174.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_174.scale = 0.0009250070434063673;
    operand_174.zeroPoint = 131;
    operand_174.dimensionCount = 4;
    const uint32_t dimensions_174[] = {60, 1, 1, 128};
    operand_174.dimensions = dimensions_174;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_174), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_175{};
    operand_175.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_175.scale = 2.462215888954233e-05;
    operand_175.zeroPoint = 0;
    operand_175.dimensionCount = 1;
    const uint32_t dimensions_175[] = {60};
    operand_175.dimensions = dimensions_175;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_175), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_176{};
    operand_176.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_176.scale = 0.008264735341072083;
    operand_176.zeroPoint = 137;
    operand_176.dimensionCount = 4;
    const uint32_t dimensions_176[] = {1, 0, 0, 60};
    operand_176.dimensions = dimensions_176;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_176), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_177{};
    operand_177.type = ANEURALNETWORKS_TENSOR_QUANT16_SYMM;
    operand_177.scale = 0.125;
    operand_177.zeroPoint = 0;
    operand_177.dimensionCount = 2;
    const uint32_t dimensions_177[] = {15, 4};
    operand_177.dimensions = dimensions_177;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_177), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_178{};
    operand_178.type = ANEURALNETWORKS_FLOAT32;
    operand_178.scale = 0;
    operand_178.zeroPoint = 0;
    operand_178.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_178), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_179{};
    operand_179.type = ANEURALNETWORKS_INT32;
    operand_179.scale = 0;
    operand_179.zeroPoint = 0;
    operand_179.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_179), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_180{};
    operand_180.type = ANEURALNETWORKS_INT32;
    operand_180.scale = 0;
    operand_180.zeroPoint = 0;
    operand_180.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_180), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_181{};
    operand_181.type = ANEURALNETWORKS_FLOAT32;
    operand_181.scale = 0;
    operand_181.zeroPoint = 0;
    operand_181.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_181), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_182{};
    operand_182.type = ANEURALNETWORKS_FLOAT32;
    operand_182.scale = 0;
    operand_182.zeroPoint = 0;
    operand_182.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_182), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_183{};
    operand_183.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_183.scale = 0.08332997560501099;
    operand_183.zeroPoint = 148;
    operand_183.dimensionCount = 1;
    const uint32_t dimensions_183[] = {0};
    operand_183.dimensions = dimensions_183;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_183), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_184{};
    operand_184.type = ANEURALNETWORKS_TENSOR_QUANT16_ASYMM;
    operand_184.scale = 0.125;
    operand_184.zeroPoint = 0;
    operand_184.dimensionCount = 2;
    const uint32_t dimensions_184[] = {0, 4};
    operand_184.dimensions = dimensions_184;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_184), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_185{};
    operand_185.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_185.scale = 0;
    operand_185.zeroPoint = 0;
    operand_185.dimensionCount = 1;
    const uint32_t dimensions_185[] = {0};
    operand_185.dimensions = dimensions_185;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_185), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_186{};
    operand_186.type = ANEURALNETWORKS_INT32;
    operand_186.scale = 0;
    operand_186.zeroPoint = 0;
    operand_186.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_186), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_187{};
    operand_187.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_187.scale = 0.009147729724645615;
    operand_187.zeroPoint = 121;
    operand_187.dimensionCount = 4;
    const uint32_t dimensions_187[] = {0, 6, 6, 128};
    operand_187.dimensions = dimensions_187;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_187), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_188{};
    operand_188.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_188.scale = 0.003680879715830088;
    operand_188.zeroPoint = 146;
    operand_188.dimensionCount = 4;
    const uint32_t dimensions_188[] = {512, 1, 1, 128};
    operand_188.dimensions = dimensions_188;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_188), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_189{};
    operand_189.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_189.scale = 3.367169483681209e-05;
    operand_189.zeroPoint = 0;
    operand_189.dimensionCount = 1;
    const uint32_t dimensions_189[] = {512};
    operand_189.dimensions = dimensions_189;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_189), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_190{};
    operand_190.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_190.scale = 0.003791309893131256;
    operand_190.zeroPoint = 0;
    operand_190.dimensionCount = 4;
    const uint32_t dimensions_190[] = {0, 6, 6, 512};
    operand_190.dimensions = dimensions_190;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_190), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_191{};
    operand_191.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_191.scale = 0.001269564847461879;
    operand_191.zeroPoint = 138;
    operand_191.dimensionCount = 4;
    const uint32_t dimensions_191[] = {1, 3, 3, 512};
    operand_191.dimensions = dimensions_191;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_191), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_192{};
    operand_192.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_192.scale = 4.813313807972008e-06;
    operand_192.zeroPoint = 0;
    operand_192.dimensionCount = 1;
    const uint32_t dimensions_192[] = {512};
    operand_192.dimensions = dimensions_192;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_192), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_193{};
    operand_193.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_193.scale = 0.001495834090746939;
    operand_193.zeroPoint = 103;
    operand_193.dimensionCount = 4;
    const uint32_t dimensions_193[] = {0, 3, 3, 512};
    operand_193.dimensions = dimensions_193;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_193), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_194{};
    operand_194.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_194.scale = 0.008620671927928925;
    operand_194.zeroPoint = 120;
    operand_194.dimensionCount = 4;
    const uint32_t dimensions_194[] = {128, 1, 1, 512};
    operand_194.dimensions = dimensions_194;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_194), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_195{};
    operand_195.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_195.scale = 1.289509418711532e-05;
    operand_195.zeroPoint = 0;
    operand_195.dimensionCount = 1;
    const uint32_t dimensions_195[] = {128};
    operand_195.dimensions = dimensions_195;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_195), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_196{};
    operand_196.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_196.scale = 0.004329186864197254;
    operand_196.zeroPoint = 133;
    operand_196.dimensionCount = 4;
    const uint32_t dimensions_196[] = {0, 3, 3, 128};
    operand_196.dimensions = dimensions_196;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_196), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_197{};
    operand_197.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_197.scale = 0.003237461671233177;
    operand_197.zeroPoint = 129;
    operand_197.dimensionCount = 4;
    const uint32_t dimensions_197[] = {768, 1, 1, 128};
    operand_197.dimensions = dimensions_197;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_197), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_198{};
    operand_198.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_198.scale = 1.401557619828964e-05;
    operand_198.zeroPoint = 0;
    operand_198.dimensionCount = 1;
    const uint32_t dimensions_198[] = {768};
    operand_198.dimensions = dimensions_198;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_198), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_199{};
    operand_199.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_199.scale = 0.00272013433277607;
    operand_199.zeroPoint = 0;
    operand_199.dimensionCount = 4;
    const uint32_t dimensions_199[] = {0, 3, 3, 768};
    operand_199.dimensions = dimensions_199;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_199), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_200{};
    operand_200.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_200.scale = 0.001447727903723717;
    operand_200.zeroPoint = 140;
    operand_200.dimensionCount = 4;
    const uint32_t dimensions_200[] = {1, 3, 3, 768};
    operand_200.dimensions = dimensions_200;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_200), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_201{};
    operand_201.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_201.scale = 3.938014287996339e-06;
    operand_201.zeroPoint = 0;
    operand_201.dimensionCount = 1;
    const uint32_t dimensions_201[] = {768};
    operand_201.dimensions = dimensions_201;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_201), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_202{};
    operand_202.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_202.scale = 0.001003918354399502;
    operand_202.zeroPoint = 128;
    operand_202.dimensionCount = 4;
    const uint32_t dimensions_202[] = {0, 3, 3, 768};
    operand_202.dimensions = dimensions_202;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_202), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_203{};
    operand_203.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_203.scale = 0.02241912484169006;
    operand_203.zeroPoint = 132;
    operand_203.dimensionCount = 4;
    const uint32_t dimensions_203[] = {128, 1, 1, 768};
    operand_203.dimensions = dimensions_203;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_203), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_204{};
    operand_204.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_204.scale = 2.250697070849128e-05;
    operand_204.zeroPoint = 0;
    operand_204.dimensionCount = 1;
    const uint32_t dimensions_204[] = {128};
    operand_204.dimensions = dimensions_204;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_204), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_205{};
    operand_205.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_205.scale = 0.004013048950582743;
    operand_205.zeroPoint = 123;
    operand_205.dimensionCount = 4;
    const uint32_t dimensions_205[] = {0, 3, 3, 128};
    operand_205.dimensions = dimensions_205;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_205), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_206{};
    operand_206.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_206.scale = 0.005564078688621521;
    operand_206.zeroPoint = 132;
    operand_206.dimensionCount = 4;
    const uint32_t dimensions_206[] = {0, 3, 3, 128};
    operand_206.dimensions = dimensions_206;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_206), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_207{};
    operand_207.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_207.scale = 0.002945196582004428;
    operand_207.zeroPoint = 130;
    operand_207.dimensionCount = 4;
    const uint32_t dimensions_207[] = {768, 1, 1, 128};
    operand_207.dimensions = dimensions_207;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_207), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_208{};
    operand_208.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_208.scale = 1.638730645936448e-05;
    operand_208.zeroPoint = 0;
    operand_208.dimensionCount = 1;
    const uint32_t dimensions_208[] = {768};
    operand_208.dimensions = dimensions_208;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_208), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_209{};
    operand_209.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_209.scale = 0.002767552156001329;
    operand_209.zeroPoint = 0;
    operand_209.dimensionCount = 4;
    const uint32_t dimensions_209[] = {0, 3, 3, 768};
    operand_209.dimensions = dimensions_209;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_209), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_210{};
    operand_210.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_210.scale = 0.001267897896468639;
    operand_210.zeroPoint = 111;
    operand_210.dimensionCount = 4;
    const uint32_t dimensions_210[] = {1, 3, 3, 768};
    operand_210.dimensions = dimensions_210;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_210), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_211{};
    operand_211.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_211.scale = 3.508973350108135e-06;
    operand_211.zeroPoint = 0;
    operand_211.dimensionCount = 1;
    const uint32_t dimensions_211[] = {768};
    operand_211.dimensions = dimensions_211;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_211), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_212{};
    operand_212.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_212.scale = 0.001003496232442558;
    operand_212.zeroPoint = 103;
    operand_212.dimensionCount = 4;
    const uint32_t dimensions_212[] = {0, 3, 3, 768};
    operand_212.dimensions = dimensions_212;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_212), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_213{};
    operand_213.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_213.scale = 0.04008430987596512;
    operand_213.zeroPoint = 130;
    operand_213.dimensionCount = 4;
    const uint32_t dimensions_213[] = {128, 1, 1, 768};
    operand_213.dimensions = dimensions_213;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_213), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_214{};
    operand_214.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_214.scale = 4.022445500595495e-05;
    operand_214.zeroPoint = 0;
    operand_214.dimensionCount = 1;
    const uint32_t dimensions_214[] = {128};
    operand_214.dimensions = dimensions_214;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_214), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_215{};
    operand_215.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_215.scale = 0.007019979413598776;
    operand_215.zeroPoint = 127;
    operand_215.dimensionCount = 4;
    const uint32_t dimensions_215[] = {0, 3, 3, 128};
    operand_215.dimensions = dimensions_215;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_215), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_216{};
    operand_216.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_216.scale = 0.008132008835673332;
    operand_216.zeroPoint = 113;
    operand_216.dimensionCount = 4;
    const uint32_t dimensions_216[] = {0, 3, 3, 128};
    operand_216.dimensions = dimensions_216;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_216), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_217{};
    operand_217.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_217.scale = 0.002510206308215857;
    operand_217.zeroPoint = 121;
    operand_217.dimensionCount = 4;
    const uint32_t dimensions_217[] = {768, 1, 1, 128};
    operand_217.dimensions = dimensions_217;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_217), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_218{};
    operand_218.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_218.scale = 2.041302104771603e-05;
    operand_218.zeroPoint = 0;
    operand_218.dimensionCount = 1;
    const uint32_t dimensions_218[] = {768};
    operand_218.dimensions = dimensions_218;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_218), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_219{};
    operand_219.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_219.scale = 0.002694383496418595;
    operand_219.zeroPoint = 0;
    operand_219.dimensionCount = 4;
    const uint32_t dimensions_219[] = {0, 3, 3, 768};
    operand_219.dimensions = dimensions_219;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_219), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_220{};
    operand_220.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_220.scale = 0.0008893656777217984;
    operand_220.zeroPoint = 133;
    operand_220.dimensionCount = 4;
    const uint32_t dimensions_220[] = {1, 3, 3, 768};
    operand_220.dimensions = dimensions_220;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_220), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_221{};
    operand_221.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_221.scale = 2.3962923023646e-06;
    operand_221.zeroPoint = 0;
    operand_221.dimensionCount = 1;
    const uint32_t dimensions_221[] = {768};
    operand_221.dimensions = dimensions_221;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_221), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_222{};
    operand_222.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_222.scale = 0.001002407167106867;
    operand_222.zeroPoint = 131;
    operand_222.dimensionCount = 4;
    const uint32_t dimensions_222[] = {0, 3, 3, 768};
    operand_222.dimensions = dimensions_222;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_222), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_223{};
    operand_223.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_223.scale = 0.05506842583417892;
    operand_223.zeroPoint = 153;
    operand_223.dimensionCount = 4;
    const uint32_t dimensions_223[] = {160, 1, 1, 768};
    operand_223.dimensions = dimensions_223;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_223), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_224{};
    operand_224.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_224.scale = 5.520098784472793e-05;
    operand_224.zeroPoint = 0;
    operand_224.dimensionCount = 1;
    const uint32_t dimensions_224[] = {160};
    operand_224.dimensions = dimensions_224;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_224), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_225{};
    operand_225.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_225.scale = 0.005563139915466309;
    operand_225.zeroPoint = 126;
    operand_225.dimensionCount = 4;
    const uint32_t dimensions_225[] = {0, 3, 3, 160};
    operand_225.dimensions = dimensions_225;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_225), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_226{};
    operand_226.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_226.scale = 0.02526126243174076;
    operand_226.zeroPoint = 112;
    operand_226.dimensionCount = 4;
    const uint32_t dimensions_226[] = {160, 1, 1, 160};
    operand_226.dimensions = dimensions_226;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_226), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_227{};
    operand_227.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_227.scale = 0.0001405319344485179;
    operand_227.zeroPoint = 0;
    operand_227.dimensionCount = 1;
    const uint32_t dimensions_227[] = {160};
    operand_227.dimensions = dimensions_227;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_227), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_228{};
    operand_228.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_228.scale = 0.04058342799544334;
    operand_228.zeroPoint = 0;
    operand_228.dimensionCount = 4;
    const uint32_t dimensions_228[] = {0, 3, 3, 160};
    operand_228.dimensions = dimensions_228;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_228), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_229{};
    operand_229.type = ANEURALNETWORKS_INT32;
    operand_229.scale = 0;
    operand_229.zeroPoint = 0;
    operand_229.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_229), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_230{};
    operand_230.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_230.scale = 0.04058342799544334;
    operand_230.zeroPoint = 0;
    operand_230.dimensionCount = 4;
    const uint32_t dimensions_230[] = {0, 1, 1, 160};
    operand_230.dimensions = dimensions_230;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_230), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_231{};
    operand_231.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_231.scale = 0.005672636907547712;
    operand_231.zeroPoint = 136;
    operand_231.dimensionCount = 2;
    const uint32_t dimensions_231[] = {81, 160};
    operand_231.dimensions = dimensions_231;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_231), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_232{};
    operand_232.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_232.scale = 0.0002302150533068925;
    operand_232.zeroPoint = 0;
    operand_232.dimensionCount = 1;
    const uint32_t dimensions_232[] = {81};
    operand_232.dimensions = dimensions_232;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_232), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_233{};
    operand_233.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_233.scale = 0.08092430979013443;
    operand_233.zeroPoint = 80;
    operand_233.dimensionCount = 2;
    const uint32_t dimensions_233[] = {0, 81};
    operand_233.dimensions = dimensions_233;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_233), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_234{};
    operand_234.type = ANEURALNETWORKS_FLOAT32;
    operand_234.scale = 0;
    operand_234.zeroPoint = 0;
    operand_234.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_234), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_235{};
    operand_235.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_235.scale = 0.00390625;
    operand_235.zeroPoint = 0;
    operand_235.dimensionCount = 2;
    const uint32_t dimensions_235[] = {0, 81};
    operand_235.dimensions = dimensions_235;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_235), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_236{};
    operand_236.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_236.scale = 0.0006408203043974936;
    operand_236.zeroPoint = 139;
    operand_236.dimensionCount = 2;
    const uint32_t dimensions_236[] = {324, 160};
    operand_236.dimensions = dimensions_236;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_236), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_237{};
    operand_237.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_237.scale = 2.600668449304067e-05;
    operand_237.zeroPoint = 0;
    operand_237.dimensionCount = 1;
    const uint32_t dimensions_237[] = {324};
    operand_237.dimensions = dimensions_237;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_237), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_238{};
    operand_238.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_238.scale = 0.004951907321810722;
    operand_238.zeroPoint = 131;
    operand_238.dimensionCount = 2;
    const uint32_t dimensions_238[] = {0, 324};
    operand_238.dimensions = dimensions_238;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_238), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_239{};
    operand_239.type = ANEURALNETWORKS_TENSOR_QUANT16_ASYMM;
    operand_239.scale = 0.125;
    operand_239.zeroPoint = 0;
    operand_239.dimensionCount = 2;
    const uint32_t dimensions_239[] = {0, 324};
    operand_239.dimensions = dimensions_239;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_239), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_240{};
    operand_240.type = ANEURALNETWORKS_FLOAT32;
    operand_240.scale = 0;
    operand_240.zeroPoint = 0;
    operand_240.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_240), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_241{};
    operand_241.type = ANEURALNETWORKS_FLOAT32;
    operand_241.scale = 0;
    operand_241.zeroPoint = 0;
    operand_241.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_241), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_242{};
    operand_242.type = ANEURALNETWORKS_FLOAT32;
    operand_242.scale = 0;
    operand_242.zeroPoint = 0;
    operand_242.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_242), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_243{};
    operand_243.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_243.scale = 0.00390625;
    operand_243.zeroPoint = 0;
    operand_243.dimensionCount = 1;
    const uint32_t dimensions_243[] = {0};
    operand_243.dimensions = dimensions_243;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_243), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_244{};
    operand_244.type = ANEURALNETWORKS_TENSOR_QUANT16_ASYMM;
    operand_244.scale = 0.125;
    operand_244.zeroPoint = 0;
    operand_244.dimensionCount = 2;
    const uint32_t dimensions_244[] = {0, 4};
    operand_244.dimensions = dimensions_244;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_244), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_245{};
    operand_245.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_245.scale = 0;
    operand_245.zeroPoint = 0;
    operand_245.dimensionCount = 1;
    const uint32_t dimensions_245[] = {0};
    operand_245.dimensions = dimensions_245;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_245), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_246{};
    operand_246.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_246.scale = 0;
    operand_246.zeroPoint = 0;
    operand_246.dimensionCount = 1;
    const uint32_t dimensions_246[] = {0};
    operand_246.dimensions = dimensions_246;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_246), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_247{};
    operand_247.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_247.scale = 0.009006229229271412;
    operand_247.zeroPoint = 119;
    operand_247.dimensionCount = 4;
    const uint32_t dimensions_247[] = {0, 6, 6, 128};
    operand_247.dimensions = dimensions_247;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_247), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_248{};
    operand_248.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_248.scale = 0.002211635699495673;
    operand_248.zeroPoint = 132;
    operand_248.dimensionCount = 4;
    const uint32_t dimensions_248[] = {512, 1, 1, 128};
    operand_248.dimensions = dimensions_248;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_248), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_249{};
    operand_249.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_249.scale = 1.991849785554223e-05;
    operand_249.zeroPoint = 0;
    operand_249.dimensionCount = 1;
    const uint32_t dimensions_249[] = {512};
    operand_249.dimensions = dimensions_249;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_249), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_250{};
    operand_250.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_250.scale = 0.002592636970803142;
    operand_250.zeroPoint = 0;
    operand_250.dimensionCount = 4;
    const uint32_t dimensions_250[] = {0, 6, 6, 512};
    operand_250.dimensions = dimensions_250;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_250), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_251{};
    operand_251.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_251.scale = 0.001000639051198959;
    operand_251.zeroPoint = 148;
    operand_251.dimensionCount = 4;
    const uint32_t dimensions_251[] = {1, 3, 3, 512};
    operand_251.dimensions = dimensions_251;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_251), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_252{};
    operand_252.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_252.scale = 2.5942936190404e-06;
    operand_252.zeroPoint = 0;
    operand_252.dimensionCount = 1;
    const uint32_t dimensions_252[] = {512};
    operand_252.dimensions = dimensions_252;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_252), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_253{};
    operand_253.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_253.scale = 0.001002595527097583;
    operand_253.zeroPoint = 116;
    operand_253.dimensionCount = 4;
    const uint32_t dimensions_253[] = {0, 6, 6, 512};
    operand_253.dimensions = dimensions_253;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_253), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_254{};
    operand_254.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_254.scale = 0.01961961947381496;
    operand_254.zeroPoint = 135;
    operand_254.dimensionCount = 4;
    const uint32_t dimensions_254[] = {128, 1, 1, 512};
    operand_254.dimensions = dimensions_254;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_254), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_255{};
    operand_255.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_255.scale = 1.967054413398728e-05;
    operand_255.zeroPoint = 0;
    operand_255.dimensionCount = 1;
    const uint32_t dimensions_255[] = {128};
    operand_255.dimensions = dimensions_255;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_255), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_256{};
    operand_256.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_256.scale = 0.003791325259953737;
    operand_256.zeroPoint = 133;
    operand_256.dimensionCount = 4;
    const uint32_t dimensions_256[] = {0, 6, 6, 128};
    operand_256.dimensions = dimensions_256;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_256), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_257{};
    operand_257.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_257.scale = 0.009337191469967365;
    operand_257.zeroPoint = 121;
    operand_257.dimensionCount = 4;
    const uint32_t dimensions_257[] = {0, 6, 6, 128};
    operand_257.dimensions = dimensions_257;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_257), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_258{};
    operand_258.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_258.scale = 0.002133074915036559;
    operand_258.zeroPoint = 128;
    operand_258.dimensionCount = 4;
    const uint32_t dimensions_258[] = {768, 1, 1, 128};
    operand_258.dimensions = dimensions_258;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_258), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_259{};
    operand_259.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_259.scale = 1.991692988667637e-05;
    operand_259.zeroPoint = 0;
    operand_259.dimensionCount = 1;
    const uint32_t dimensions_259[] = {768};
    operand_259.dimensions = dimensions_259;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_259), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_260{};
    operand_260.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_260.scale = 0.002098787110298872;
    operand_260.zeroPoint = 0;
    operand_260.dimensionCount = 4;
    const uint32_t dimensions_260[] = {0, 6, 6, 768};
    operand_260.dimensions = dimensions_260;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_260), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_261{};
    operand_261.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_261.scale = 0.0008608275675214827;
    operand_261.zeroPoint = 124;
    operand_261.dimensionCount = 4;
    const uint32_t dimensions_261[] = {1, 3, 3, 768};
    operand_261.dimensions = dimensions_261;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_261), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_262{};
    operand_262.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_262.scale = 1.806693830985751e-06;
    operand_262.zeroPoint = 0;
    operand_262.dimensionCount = 1;
    const uint32_t dimensions_262[] = {768};
    operand_262.dimensions = dimensions_262;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_262), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_263{};
    operand_263.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_263.scale = 0.001001805765554309;
    operand_263.zeroPoint = 150;
    operand_263.dimensionCount = 4;
    const uint32_t dimensions_263[] = {0, 6, 6, 768};
    operand_263.dimensions = dimensions_263;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_263), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_264{};
    operand_264.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_264.scale = 0.0244825966656208;
    operand_264.zeroPoint = 125;
    operand_264.dimensionCount = 4;
    const uint32_t dimensions_264[] = {128, 1, 1, 768};
    operand_264.dimensions = dimensions_264;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_264), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_265{};
    operand_265.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_265.scale = 2.452680564601906e-05;
    operand_265.zeroPoint = 0;
    operand_265.dimensionCount = 1;
    const uint32_t dimensions_265[] = {128};
    operand_265.dimensions = dimensions_265;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_265), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_266{};
    operand_266.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_266.scale = 0.003958381246775389;
    operand_266.zeroPoint = 126;
    operand_266.dimensionCount = 4;
    const uint32_t dimensions_266[] = {0, 6, 6, 128};
    operand_266.dimensions = dimensions_266;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_266), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_267{};
    operand_267.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_267.scale = 0.009366916492581367;
    operand_267.zeroPoint = 121;
    operand_267.dimensionCount = 4;
    const uint32_t dimensions_267[] = {0, 6, 6, 128};
    operand_267.dimensions = dimensions_267;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_267), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_268{};
    operand_268.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_268.scale = 0.002321642125025392;
    operand_268.zeroPoint = 121;
    operand_268.dimensionCount = 4;
    const uint32_t dimensions_268[] = {768, 1, 1, 128};
    operand_268.dimensions = dimensions_268;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_268), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_269{};
    operand_269.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_269.scale = 2.17466258618515e-05;
    operand_269.zeroPoint = 0;
    operand_269.dimensionCount = 1;
    const uint32_t dimensions_269[] = {768};
    operand_269.dimensions = dimensions_269;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_269), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_270{};
    operand_270.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_270.scale = 0.002672255504876375;
    operand_270.zeroPoint = 0;
    operand_270.dimensionCount = 4;
    const uint32_t dimensions_270[] = {0, 6, 6, 768};
    operand_270.dimensions = dimensions_270;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_270), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_271{};
    operand_271.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_271.scale = 0.0008156994008459151;
    operand_271.zeroPoint = 131;
    operand_271.dimensionCount = 4;
    const uint32_t dimensions_271[] = {1, 3, 3, 768};
    operand_271.dimensions = dimensions_271;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_271), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_272{};
    operand_272.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_272.scale = 2.179757075282396e-06;
    operand_272.zeroPoint = 0;
    operand_272.dimensionCount = 1;
    const uint32_t dimensions_272[] = {768};
    operand_272.dimensions = dimensions_272;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_272), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_273{};
    operand_273.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_273.scale = 0.00100218434818089;
    operand_273.zeroPoint = 104;
    operand_273.dimensionCount = 4;
    const uint32_t dimensions_273[] = {0, 6, 6, 768};
    operand_273.dimensions = dimensions_273;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_273), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_274{};
    operand_274.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_274.scale = 0.02847485058009624;
    operand_274.zeroPoint = 121;
    operand_274.dimensionCount = 4;
    const uint32_t dimensions_274[] = {128, 1, 1, 768};
    operand_274.dimensions = dimensions_274;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_274), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_275{};
    operand_275.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_275.scale = 2.853704972949345e-05;
    operand_275.zeroPoint = 0;
    operand_275.dimensionCount = 1;
    const uint32_t dimensions_275[] = {128};
    operand_275.dimensions = dimensions_275;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_275), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_276{};
    operand_276.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_276.scale = 0.005113502498716116;
    operand_276.zeroPoint = 134;
    operand_276.dimensionCount = 4;
    const uint32_t dimensions_276[] = {0, 6, 6, 128};
    operand_276.dimensions = dimensions_276;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_276), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_277{};
    operand_277.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_277.scale = 0.009635390713810921;
    operand_277.zeroPoint = 126;
    operand_277.dimensionCount = 4;
    const uint32_t dimensions_277[] = {0, 6, 6, 128};
    operand_277.dimensions = dimensions_277;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_277), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_278{};
    operand_278.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_278.scale = 0.002073407173156738;
    operand_278.zeroPoint = 138;
    operand_278.dimensionCount = 4;
    const uint32_t dimensions_278[] = {768, 1, 1, 128};
    operand_278.dimensions = dimensions_278;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_278), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_279{};
    operand_279.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_279.scale = 1.997808794840239e-05;
    operand_279.zeroPoint = 0;
    operand_279.dimensionCount = 1;
    const uint32_t dimensions_279[] = {768};
    operand_279.dimensions = dimensions_279;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_279), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_280{};
    operand_280.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_280.scale = 0.00225812871940434;
    operand_280.zeroPoint = 0;
    operand_280.dimensionCount = 4;
    const uint32_t dimensions_280[] = {0, 6, 6, 768};
    operand_280.dimensions = dimensions_280;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_280), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_281{};
    operand_281.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_281.scale = 0.0009067427599802613;
    operand_281.zeroPoint = 116;
    operand_281.dimensionCount = 4;
    const uint32_t dimensions_281[] = {1, 3, 3, 768};
    operand_281.dimensions = dimensions_281;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_281), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_282{};
    operand_282.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_282.scale = 2.047542011496262e-06;
    operand_282.zeroPoint = 0;
    operand_282.dimensionCount = 1;
    const uint32_t dimensions_282[] = {768};
    operand_282.dimensions = dimensions_282;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_282), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_283{};
    operand_283.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_283.scale = 0.001002039294689894;
    operand_283.zeroPoint = 121;
    operand_283.dimensionCount = 4;
    const uint32_t dimensions_283[] = {0, 6, 6, 768};
    operand_283.dimensions = dimensions_283;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_283), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_284{};
    operand_284.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_284.scale = 0.0345500223338604;
    operand_284.zeroPoint = 134;
    operand_284.dimensionCount = 4;
    const uint32_t dimensions_284[] = {128, 1, 1, 768};
    operand_284.dimensions = dimensions_284;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_284), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_285{};
    operand_285.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_285.scale = 3.462047970970161e-05;
    operand_285.zeroPoint = 0;
    operand_285.dimensionCount = 1;
    const uint32_t dimensions_285[] = {128};
    operand_285.dimensions = dimensions_285;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_285), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_286{};
    operand_286.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_286.scale = 0.005219598766416311;
    operand_286.zeroPoint = 129;
    operand_286.dimensionCount = 4;
    const uint32_t dimensions_286[] = {0, 6, 6, 128};
    operand_286.dimensions = dimensions_286;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_286), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_287{};
    operand_287.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_287.scale = 0.01011695526540279;
    operand_287.zeroPoint = 125;
    operand_287.dimensionCount = 4;
    const uint32_t dimensions_287[] = {0, 6, 6, 128};
    operand_287.dimensions = dimensions_287;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_287), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_288{};
    operand_288.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_288.scale = 0.002151809399947524;
    operand_288.zeroPoint = 134;
    operand_288.dimensionCount = 4;
    const uint32_t dimensions_288[] = {384, 1, 1, 128};
    operand_288.dimensions = dimensions_288;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_288), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_289{};
    operand_289.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_289.scale = 2.176975976908579e-05;
    operand_289.zeroPoint = 0;
    operand_289.dimensionCount = 1;
    const uint32_t dimensions_289[] = {384};
    operand_289.dimensions = dimensions_289;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_289), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_290{};
    operand_290.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_290.scale = 0.003372935345396399;
    operand_290.zeroPoint = 0;
    operand_290.dimensionCount = 4;
    const uint32_t dimensions_290[] = {0, 6, 6, 384};
    operand_290.dimensions = dimensions_290;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_290), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_291{};
    operand_291.type = ANEURALNETWORKS_FLOAT32;
    operand_291.scale = 0;
    operand_291.zeroPoint = 0;
    operand_291.dimensionCount = 0;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_291), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_292{};
    operand_292.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_292.scale = 0.003372935345396399;
    operand_292.zeroPoint = 0;
    operand_292.dimensionCount = 4;
    const uint32_t dimensions_292[] = {0, 12, 12, 384};
    operand_292.dimensions = dimensions_292;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_292), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_293{};
    operand_293.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_293.scale = 0.001229611807502806;
    operand_293.zeroPoint = 134;
    operand_293.dimensionCount = 4;
    const uint32_t dimensions_293[] = {1, 3, 3, 384};
    operand_293.dimensions = dimensions_293;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_293), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_294{};
    operand_294.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_294.scale = 4.147401341469958e-06;
    operand_294.zeroPoint = 0;
    operand_294.dimensionCount = 1;
    const uint32_t dimensions_294[] = {384};
    operand_294.dimensions = dimensions_294;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_294), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_295{};
    operand_295.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_295.scale = 0.001418625121004879;
    operand_295.zeroPoint = 129;
    operand_295.dimensionCount = 4;
    const uint32_t dimensions_295[] = {0, 12, 12, 384};
    operand_295.dimensions = dimensions_295;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_295), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_296{};
    operand_296.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_296.scale = 0.06397756934165955;
    operand_296.zeroPoint = 123;
    operand_296.dimensionCount = 4;
    const uint32_t dimensions_296[] = {64, 1, 1, 384};
    operand_296.dimensions = dimensions_296;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_296), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_297{};
    operand_297.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_297.scale = 9.076018613995984e-05;
    operand_297.zeroPoint = 0;
    operand_297.dimensionCount = 1;
    const uint32_t dimensions_297[] = {64};
    operand_297.dimensions = dimensions_297;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_297), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_298{};
    operand_298.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_298.scale = 0.04541563242673874;
    operand_298.zeroPoint = 145;
    operand_298.dimensionCount = 4;
    const uint32_t dimensions_298[] = {0, 12, 12, 64};
    operand_298.dimensions = dimensions_298;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_298), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_299{};
    operand_299.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_299.scale = 0.003162507666274905;
    operand_299.zeroPoint = 127;
    operand_299.dimensionCount = 4;
    const uint32_t dimensions_299[] = {81, 1, 1, 64};
    operand_299.dimensions = dimensions_299;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_299), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_300{};
    operand_300.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_300.scale = 0.000143627286888659;
    operand_300.zeroPoint = 0;
    operand_300.dimensionCount = 1;
    const uint32_t dimensions_300[] = {81};
    operand_300.dimensions = dimensions_300;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_300), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_301{};
    operand_301.type = ANEURALNETWORKS_TENSOR_QUANT8_ASYMM;
    operand_301.scale = 0.08356435596942902;
    operand_301.zeroPoint = 135;
    operand_301.dimensionCount = 4;
    const uint32_t dimensions_301[] = {0, 12, 12, 81};
    operand_301.dimensions = dimensions_301;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_301), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_302{};
    operand_302.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    operand_302.scale = 0;
    operand_302.zeroPoint = 0;
    operand_302.dimensionCount = 4;
    const uint32_t dimensions_302[] = {0, 12, 12, 81};
    operand_302.dimensions = dimensions_302;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_302), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_303{};
    operand_303.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_303.scale = 0;
    operand_303.zeroPoint = 0;
    operand_303.dimensionCount = 1;
    const uint32_t dimensions_303[] = {4};
    operand_303.dimensions = dimensions_303;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_303), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_304{};
    operand_304.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    operand_304.scale = 0;
    operand_304.zeroPoint = 0;
    operand_304.dimensionCount = 4;
    const uint32_t dimensions_304[] = {0, 81, 12, 12};
    operand_304.dimensions = dimensions_304;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_304), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_305{};
    operand_305.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    operand_305.scale = 0;
    operand_305.zeroPoint = 0;
    operand_305.dimensionCount = 4;
    const uint32_t dimensions_305[] = {0, 81, 12, 12};
    operand_305.dimensions = dimensions_305;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_305), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_306{};
    operand_306.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_306.scale = 0;
    operand_306.zeroPoint = 0;
    operand_306.dimensionCount = 1;
    const uint32_t dimensions_306[] = {2};
    operand_306.dimensions = dimensions_306;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_306), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_307{};
    operand_307.type = ANEURALNETWORKS_TENSOR_INT32;
    operand_307.scale = 0;
    operand_307.zeroPoint = 0;
    operand_307.dimensionCount = 1;
    const uint32_t dimensions_307[] = {2};
    operand_307.dimensions = dimensions_307;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_307), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_308{};
    operand_308.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    operand_308.scale = 0;
    operand_308.zeroPoint = 0;
    operand_308.dimensionCount = 2;
    const uint32_t dimensions_308[] = {1, 1};
    operand_308.dimensions = dimensions_308;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_308), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType operand_309{};
    operand_309.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    operand_309.scale = 0;
    operand_309.zeroPoint = 0;
    operand_309.dimensionCount = 1;
    const uint32_t dimensions_309[] = {0};
    operand_309.dimensions = dimensions_309;
    ASSERT_EQ(ANeuralNetworksModel_addOperand(model, &operand_309), ANEURALNETWORKS_NO_ERROR);
#include "generated/maskrcnn/maskrcnn2go_quantized_const_data.cpp"
    const uint32_t input_0[] = {2, 6};
    const uint32_t output_0[] = {7};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_TRANSPOSE, 2, input_0, 1,
                                                output_0),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_1[] = {7};
    const uint32_t output_1[] = {8};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_QUANTIZE, 1, input_1, 1,
                                                output_1),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_2[] = {8, 9, 10, 11, 11, 11, 11, 12, 12, 11, 0};
    const uint32_t output_2[] = {13};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_2, 1,
                                                output_2),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_3[] = {13, 14, 15, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_3[] = {17};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_3, 1,
                                                output_3),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_4[] = {17, 18, 19, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_4[] = {20};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_4, 1, output_4),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_5[] = {20, 21, 22, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_5[] = {23};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_5, 1,
                                                output_5),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_6[] = {23, 13, 16};
    const uint32_t output_6[] = {24};
    ASSERT_EQ(
            ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_6, 1, output_6),
            ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_7[] = {24, 25, 26, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_7[] = {27};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_7, 1,
                                                output_7),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_8[] = {27, 28, 29, 11, 11, 11, 11, 12, 12, 11, 16, 0};
    const uint32_t output_8[] = {30};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_8, 1, output_8),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_9[] = {30, 31, 32, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_9[] = {33};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_9, 1,
                                                output_9),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_10[] = {33, 34, 35, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_10[] = {36};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_10, 1,
                                                output_10),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_11[] = {36, 37, 38, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_11[] = {39};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_11, 1, output_11),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_12[] = {39, 40, 41, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_12[] = {42};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_12, 1,
                                                output_12),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_13[] = {42, 33, 16};
    const uint32_t output_13[] = {43};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_13, 1,
                                                output_13),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_14[] = {43, 44, 45, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_14[] = {46};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_14, 1,
                                                output_14),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_15[] = {46, 47, 48, 11, 11, 11, 11, 12, 12, 11, 16, 0};
    const uint32_t output_15[] = {49};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_15, 1, output_15),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_16[] = {49, 50, 51, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_16[] = {52};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_16, 1,
                                                output_16),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_17[] = {52, 53, 54, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_17[] = {55};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_17, 1,
                                                output_17),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_18[] = {55, 56, 57, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_18[] = {58};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_18, 1, output_18),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_19[] = {58, 59, 60, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_19[] = {61};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_19, 1,
                                                output_19),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_20[] = {61, 52, 16};
    const uint32_t output_20[] = {62};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_20, 1,
                                                output_20),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_21[] = {62, 63, 64, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_21[] = {65};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_21, 1,
                                                output_21),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_22[] = {65, 66, 67, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_22[] = {68};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_22, 1, output_22),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_23[] = {68, 69, 70, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_23[] = {71};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_23, 1,
                                                output_23),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_24[] = {71, 62, 16};
    const uint32_t output_24[] = {72};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_24, 1,
                                                output_24),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_25[] = {72, 73, 74, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_25[] = {75};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_25, 1,
                                                output_25),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_26[] = {75, 76, 77, 11, 11, 11, 11, 12, 12, 11, 16, 0};
    const uint32_t output_26[] = {78};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_26, 1, output_26),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_27[] = {78, 79, 80, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_27[] = {81};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_27, 1,
                                                output_27),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_28[] = {81, 82, 83, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_28[] = {84};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_28, 1,
                                                output_28),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_29[] = {84, 85, 86, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_29[] = {87};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_29, 1, output_29),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_30[] = {87, 88, 89, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_30[] = {90};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_30, 1,
                                                output_30),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_31[] = {90, 81, 16};
    const uint32_t output_31[] = {91};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_31, 1,
                                                output_31),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_32[] = {91, 92, 93, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_32[] = {94};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_32, 1,
                                                output_32),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_33[] = {94, 95, 96, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_33[] = {97};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_33, 1, output_33),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_34[] = {97, 98, 99, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_34[] = {100};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_34, 1,
                                                output_34),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_35[] = {100, 91, 16};
    const uint32_t output_35[] = {101};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_35, 1,
                                                output_35),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_36[] = {101, 102, 103, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_36[] = {104};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_36, 1,
                                                output_36),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_37[] = {104, 105, 106, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_37[] = {107};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_37, 1, output_37),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_38[] = {107, 108, 109, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_38[] = {110};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_38, 1,
                                                output_38),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_39[] = {110, 101, 16};
    const uint32_t output_39[] = {111};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_39, 1,
                                                output_39),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_40[] = {111, 112, 113, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_40[] = {114};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_40, 1,
                                                output_40),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_41[] = {114, 115, 116, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_41[] = {117};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_41, 1, output_41),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_42[] = {117, 118, 119, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_42[] = {120};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_42, 1,
                                                output_42),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_43[] = {120, 121, 122, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_43[] = {123};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_43, 1,
                                                output_43),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_44[] = {123, 124, 125, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_44[] = {126};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_44, 1, output_44),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_45[] = {126, 127, 128, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_45[] = {129};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_45, 1,
                                                output_45),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_46[] = {129, 120, 16};
    const uint32_t output_46[] = {130};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_46, 1,
                                                output_46),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_47[] = {130, 131, 132, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_47[] = {133};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_47, 1,
                                                output_47),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_48[] = {133, 134, 135, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_48[] = {136};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_48, 1, output_48),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_49[] = {136, 137, 138, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_49[] = {139};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_49, 1,
                                                output_49),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_50[] = {139, 130, 16};
    const uint32_t output_50[] = {140};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_50, 1,
                                                output_50),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_51[] = {140, 141, 142, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_51[] = {143};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_51, 1,
                                                output_51),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_52[] = {143, 144, 145, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_52[] = {146};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_52, 1, output_52),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_53[] = {146, 147, 148, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_53[] = {149};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_53, 1,
                                                output_53),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_54[] = {149, 140, 16};
    const uint32_t output_54[] = {150};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_54, 1,
                                                output_54),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_55[] = {150, 151, 152, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_55[] = {153};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_55, 1,
                                                output_55),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_56[] = {153, 154, 155, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_56[] = {156};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_56, 1, output_56),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_57[] = {156, 157, 158, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_57[] = {159};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_57, 1,
                                                output_57),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_58[] = {159, 150, 16};
    const uint32_t output_58[] = {160};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_58, 1,
                                                output_58),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_59[] = {160, 161, 162, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_59[] = {163};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_59, 1,
                                                output_59),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_60[] = {163, 164, 165, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_60[] = {166};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_60, 1, output_60),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_61[] = {166, 167, 168, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_61[] = {169};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_61, 1,
                                                output_61),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_62[] = {169, 160, 16};
    const uint32_t output_62[] = {170};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_62, 1,
                                                output_62),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_63[] = {170, 171, 172, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_63[] = {173};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_63, 1,
                                                output_63),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_64[] = {170, 174, 175, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_64[] = {176};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_64, 1,
                                                output_64),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_65[] = {173, 176, 177, 5, 178, 178, 179, 180, 181, 182, 0};
    const uint32_t output_65[] = {183, 184, 185};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_GENERATE_PROPOSALS, 11,
                                                input_65, 3, output_65),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_66[] = {140, 184, 185, 186, 186, 178, 178, 16, 16, 0};
    const uint32_t output_66[] = {187};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ROI_ALIGN, 10, input_66, 1,
                                                output_66),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_67[] = {187, 188, 189, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_67[] = {190};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_67, 1,
                                                output_67),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_68[] = {190, 191, 192, 11, 11, 11, 11, 12, 12, 11, 16, 0};
    const uint32_t output_68[] = {193};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_68, 1, output_68),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_69[] = {193, 194, 195, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_69[] = {196};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_69, 1,
                                                output_69),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_70[] = {196, 197, 198, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_70[] = {199};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_70, 1,
                                                output_70),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_71[] = {199, 200, 201, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_71[] = {202};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_71, 1, output_71),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_72[] = {202, 203, 204, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_72[] = {205};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_72, 1,
                                                output_72),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_73[] = {205, 196, 16};
    const uint32_t output_73[] = {206};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_73, 1,
                                                output_73),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_74[] = {206, 207, 208, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_74[] = {209};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_74, 1,
                                                output_74),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_75[] = {209, 210, 211, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_75[] = {212};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_75, 1, output_75),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_76[] = {212, 213, 214, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_76[] = {215};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_76, 1,
                                                output_76),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_77[] = {215, 206, 16};
    const uint32_t output_77[] = {216};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_77, 1,
                                                output_77),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_78[] = {216, 217, 218, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_78[] = {219};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_78, 1,
                                                output_78),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_79[] = {219, 220, 221, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_79[] = {222};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_79, 1, output_79),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_80[] = {222, 223, 224, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_80[] = {225};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_80, 1,
                                                output_80),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_81[] = {225, 226, 227, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_81[] = {228};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_81, 1,
                                                output_81),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_82[] = {228, 16, 16, 16, 16, 11, 11, 229, 229, 16, 0};
    const uint32_t output_82[] = {230};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_AVERAGE_POOL_2D, 11,
                                                input_82, 1, output_82),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_83[] = {230, 231, 232, 16};
    const uint32_t output_83[] = {233};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_FULLY_CONNECTED, 4, input_83,
                                                1, output_83),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_84[] = {233, 234};
    const uint32_t output_84[] = {235};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_SOFTMAX, 2, input_84, 1,
                                                output_84),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_85[] = {230, 236, 237, 16};
    const uint32_t output_85[] = {238};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_FULLY_CONNECTED, 4, input_85,
                                                1, output_85),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_86[] = {184, 238, 185, 5};
    const uint32_t output_86[] = {239};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_AXIS_ALIGNED_BBOX_TRANSFORM,
                                                4, input_86, 1, output_86),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_87[] = {235, 239, 185, 240, 180, 11, 241, 242, 182};
    const uint32_t output_87[] = {243, 244, 245, 246};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_BOX_WITH_NMS_LIMIT, 9,
                                                input_87, 4, output_87),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_88[] = {140, 244, 246, 186, 186, 178, 178, 16, 16, 0};
    const uint32_t output_88[] = {247};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ROI_ALIGN, 10, input_88, 1,
                                                output_88),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_89[] = {247, 248, 249, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_89[] = {250};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_89, 1,
                                                output_89),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_90[] = {250, 251, 252, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_90[] = {253};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_90, 1, output_90),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_91[] = {253, 254, 255, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_91[] = {256};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_91, 1,
                                                output_91),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_92[] = {256, 247, 16};
    const uint32_t output_92[] = {257};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_92, 1,
                                                output_92),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_93[] = {257, 258, 259, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_93[] = {260};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_93, 1,
                                                output_93),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_94[] = {260, 261, 262, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_94[] = {263};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_94, 1, output_94),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_95[] = {263, 264, 265, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_95[] = {266};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_95, 1,
                                                output_95),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_96[] = {266, 257, 16};
    const uint32_t output_96[] = {267};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_96, 1,
                                                output_96),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_97[] = {267, 268, 269, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_97[] = {270};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_97, 1,
                                                output_97),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_98[] = {270, 271, 272, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_98[] = {273};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_98, 1, output_98),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_99[] = {273, 274, 275, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_99[] = {276};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_99, 1,
                                                output_99),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_100[] = {276, 267, 16};
    const uint32_t output_100[] = {277};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_100, 1,
                                                output_100),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_101[] = {277, 278, 279, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_101[] = {280};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_101, 1,
                                                output_101),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_102[] = {280, 281, 282, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_102[] = {283};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_102, 1, output_102),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_103[] = {283, 284, 285, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_103[] = {286};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_103, 1,
                                                output_103),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_104[] = {286, 277, 16};
    const uint32_t output_104[] = {287};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_ADD, 3, input_104, 1,
                                                output_104),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_105[] = {287, 288, 289, 16, 16, 16, 16, 11, 11, 11, 0};
    const uint32_t output_105[] = {290};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_105, 1,
                                                output_105),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_106[] = {290, 291, 291, 0};
    const uint32_t output_106[] = {292};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_RESIZE_NEAREST_NEIGHBOR, 4,
                                                input_106, 1, output_106),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_107[] = {292, 293, 294, 11, 11, 11, 11, 11, 11, 11, 16, 0};
    const uint32_t output_107[] = {295};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEPTHWISE_CONV_2D, 12,
                                                input_107, 1, output_107),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_108[] = {295, 296, 297, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_108[] = {298};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_108, 1,
                                                output_108),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_109[] = {298, 299, 300, 16, 16, 16, 16, 11, 11, 16, 0};
    const uint32_t output_109[] = {301};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_CONV_2D, 11, input_109, 1,
                                                output_109),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_110[] = {301};
    const uint32_t output_110[] = {302};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEQUANTIZE, 1, input_110, 1,
                                                output_110),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_111[] = {302, 303};
    const uint32_t output_111[] = {304};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_TRANSPOSE, 2, input_111, 1,
                                                output_111),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_112[] = {304};
    const uint32_t output_112[] = {305};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_LOGISTIC, 1, input_112, 1,
                                                output_112),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_113[] = {3, 306, 307};
    const uint32_t output_113[] = {308};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_SLICE, 3, input_113, 1,
                                                output_113),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t input_114[] = {243};
    const uint32_t output_114[] = {309};
    ASSERT_EQ(ANeuralNetworksModel_addOperation(model, ANEURALNETWORKS_DEQUANTIZE, 1, input_114, 1,
                                                output_114),
              ANEURALNETWORKS_NO_ERROR);
    const uint32_t model_inputs[] = {2, 3, 4, 5};
    const uint32_t model_outputs[] = {309, 244, 245, 305};
    ASSERT_EQ(
            ANeuralNetworksModel_identifyInputsAndOutputs(model, 4, model_inputs, 4, model_outputs),
            ANEURALNETWORKS_NO_ERROR);
    ASSERT_EQ(ANeuralNetworksModel_finish(model), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksCompilation* compilation = nullptr;
    ASSERT_EQ(ANeuralNetworksCompilation_create(model, &compilation), ANEURALNETWORKS_NO_ERROR);
    ASSERT_EQ(ANeuralNetworksCompilation_finish(compilation), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksExecution* execution = nullptr;
    ASSERT_EQ(ANeuralNetworksExecution_create(compilation, &execution), ANEURALNETWORKS_NO_ERROR);

    ANeuralNetworksOperandType input_operand_0{};
    input_operand_0.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    input_operand_0.scale = 0;
    input_operand_0.zeroPoint = 0;
    input_operand_0.dimensionCount = 4;
    const uint32_t input_dimensions_0[] = {1, 3, 462, 320};
    input_operand_0.dimensions = input_dimensions_0;

    ASSERT_EQ(ANeuralNetworksExecution_setInput(execution, 0, &input_operand_0,
                                                execution_input_buffer_0, 1774080),
              ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType input_operand_1{};
    input_operand_1.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    input_operand_1.scale = 0;
    input_operand_1.zeroPoint = 0;
    input_operand_1.dimensionCount = 2;
    const uint32_t input_dimensions_1[] = {1, 3};
    input_operand_1.dimensions = input_dimensions_1;
    const uint8_t execution_input_buffer_1[] = {0, 0, 231, 67, 0, 0, 160, 67, 198, 235, 56, 63};
    ASSERT_EQ(ANeuralNetworksExecution_setInput(execution, 1, &input_operand_1,
                                                execution_input_buffer_1, 12),
              ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType input_operand_2{};
    input_operand_2.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    input_operand_2.scale = 0;
    input_operand_2.zeroPoint = 0;
    input_operand_2.dimensionCount = 2;
    const uint32_t input_dimensions_2[] = {1, 2};
    input_operand_2.dimensions = input_dimensions_2;
    const uint8_t execution_input_buffer_2[] = {0, 0, 231, 67, 0, 0, 160, 67};
    ASSERT_EQ(ANeuralNetworksExecution_setInput(execution, 2, &input_operand_2,
                                                execution_input_buffer_2, 8),
              ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksOperandType input_operand_3{};
    input_operand_3.type = ANEURALNETWORKS_TENSOR_FLOAT32;
    input_operand_3.scale = 0;
    input_operand_3.zeroPoint = 0;
    input_operand_3.dimensionCount = 2;
    const uint32_t input_dimensions_3[] = {1, 2};
    input_operand_3.dimensions = input_dimensions_3;
    const uint8_t execution_input_buffer_3[] = {112, 14, 0, 10};
    ASSERT_EQ(ANeuralNetworksExecution_setInput(execution, 3, &input_operand_3,
                                                execution_input_buffer_3, 4),
              ANEURALNETWORKS_NO_ERROR);
    static uint8_t execution_output_buffer_0[462];
    ASSERT_EQ(
            ANeuralNetworksExecution_setOutput(execution, 0, NULL, execution_output_buffer_0, 462),
            ANEURALNETWORKS_NO_ERROR);
    static uint8_t execution_output_buffer_1[924];
    ASSERT_EQ(
            ANeuralNetworksExecution_setOutput(execution, 1, NULL, execution_output_buffer_1, 924),
            ANEURALNETWORKS_NO_ERROR);
    static uint8_t execution_output_buffer_2[462];
    ASSERT_EQ(
            ANeuralNetworksExecution_setOutput(execution, 2, NULL, execution_output_buffer_2, 462),
            ANEURALNETWORKS_NO_ERROR);
    static uint8_t execution_output_buffer_3[5388768];
    ASSERT_EQ(ANeuralNetworksExecution_setOutput(execution, 3, NULL, execution_output_buffer_3,
                                                 5388768),
              ANEURALNETWORKS_NO_ERROR);
    ASSERT_EQ(ANeuralNetworksExecution_compute(execution), ANEURALNETWORKS_NO_ERROR);
    ANeuralNetworksExecution_free(execution);
    ANeuralNetworksCompilation_free(compilation);
    ANeuralNetworksModel_free(model);
}

}  // namespace
