#
# Copyright (C) 2018 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

input0 = Input("input0", "TENSOR_FLOAT16", "{1, 1024}")
sample_count = Int32Scalar("sample_count", 128)
seeds = Parameter("seeds", "TENSOR_INT32", "{2}", [37, 42])
output0 = IgnoredOutput("output", "TENSOR_INT32", "{1, 128}")

model = Model().Operation("RANDOM_MULTINOMIAL", input0, sample_count, seeds).To(output0)

Example(({
    input0: [
        0.18163621, 0.33273480, 0.50951556, 0.08877703,
        0.51185218, 0.16734240, 0.63870587, 0.56538613,
        0.96808477, 0.56056615, 0.02934992, 0.03258404,
        0.72106282, 0.54496657, 0.22183018, 0.14761066,
        0.38261428, 0.73637053, 0.78623964, 0.00538754,
        0.17758578, 0.21533023, 0.83887367, 0.71035332,
        0.28841254, 0.24017199, 0.11599192, 0.55738622,
        0.35368502, 0.09133554, 0.81038602, 0.03550774,
        0.88201054, 0.07141711, 0.20562562, 0.99982140,
        0.36866199, 0.84549652, 0.68196711, 0.60800431,
        0.04897644, 0.79349817, 0.34294643, 0.31649012,
        0.61759858, 0.67423009, 0.14606593, 0.82548304,
        0.14200278, 0.58680437, 0.41861224, 0.86453261,
        0.80694849, 0.23185477, 0.81298628, 0.14150890,
        0.16687062, 0.03645446, 0.50345389, 0.82756624,
        0.84377461, 0.46665451, 0.91611352, 0.29161655,
        0.86669246, 0.21630808, 0.98051105, 0.71589220,
        0.54117114, 0.37597655, 0.61811207, 0.39746145,
        0.19850883, 0.10498004, 0.45398218, 0.84427816,
        0.44244307, 0.97186493, 0.02943687, 0.05995579,
        0.91047162, 0.84049659, 0.29692092, 0.37859579,
        0.68067858, 0.53199727, 0.30587859, 0.96904311,
        0.53895138, 0.80350520, 0.56936886, 0.90789923,
        0.48829865, 0.74295622, 0.07730283, 0.35745998,
        0.63879813, 0.88581710, 0.78119555, 0.34389121,
        0.00664631, 0.43921788, 0.38457199, 0.95430791,
        0.92432083, 0.29473732, 0.25805162, 0.94078243,
        0.63156303, 0.49350546, 0.60020588, 0.16993110,
        0.78426143, 0.31030305, 0.74027296, 0.86801874,
        0.71064432, 0.98042120, 0.26738505, 0.22304029,
        0.97474880, 0.93888746, 0.02851034, 0.22468271,
        0.67886092, 0.79198019, 0.56653174, 0.17544579,
        0.89579936, 0.96279060, 0.04028579, 0.58690500,
        0.72510547, 0.60705131, 0.43325570, 0.15888959,
        0.34523460, 0.56390766, 0.31160624, 0.14503308,
        0.19243339, 0.26307077, 0.53711017, 0.90120554,
        0.20798102, 0.44519176, 0.83232068, 0.82690943,
        0.23728192, 0.27897126, 0.24336233, 0.56491850,
        0.80009130, 0.91884854, 0.00823675, 0.30183011,
        0.64548693, 0.06524323, 0.02960910, 0.10885612,
        0.93308847, 0.01737334, 0.87532111, 0.64499222,
        0.80151762, 0.68087718, 0.48854077, 0.33778072,
        0.89418992, 0.00524248, 0.49021969, 0.42403950,
        0.74438303, 0.93005140, 0.98648675, 0.06316910,
        0.77617813, 0.77113286, 0.51341796, 0.49668114,
        0.85817043, 0.12039487, 0.69007245, 0.63516463,
        0.43368987, 0.03034840, 0.75404114, 0.78141053,
        0.23417318, 0.07462540, 0.02689441, 0.66631840,
        0.86519194, 0.91861606, 0.10818770, 0.42462775,
        0.26566337, 0.68942528, 0.27363712, 0.54874752,
        0.58072208, 0.18649499, 0.79037057, 0.14188329,
        0.29430633, 0.91596697, 0.40646783, 0.77726510,
        0.75446749, 0.01020716, 0.20875567, 0.73854318,
        0.73204509, 0.02641734, 0.15423192, 0.97863180,
        0.14997906, 0.56356818, 0.71459404, 0.74379692,
        0.40063276, 0.05400237, 0.51403009, 0.27387991,
        0.68738814, 0.44641846, 0.38901113, 0.52327729,
        0.97282648, 0.43078061, 0.66980505, 0.21611701,
        0.78165645, 0.01494616, 0.14573566, 0.89647321,
        0.27992757, 0.93745905, 0.95605115, 0.14323041,
        0.93223624, 0.13351544, 0.48690382, 0.48056268,
        0.58399360, 0.38147627, 0.57308770, 0.88455851,
        0.61266891, 0.88541185, 0.88516824, 0.53789164,
        0.04956664, 0.11410213, 0.47340589, 0.30371802,
        0.68811040, 0.60006376, 0.98732277, 0.11725557,
        0.91365836, 0.49581686, 0.43231324, 0.88435984,
        0.07224436, 0.35188695, 0.74323035, 0.20613255,
        0.80579434, 0.19316965, 0.05335943, 0.77709435,
        0.20689616, 0.85582175, 0.14171426, 0.05923329,
        0.57708418, 0.58697364, 0.50752432, 0.88097219,
        0.93936580, 0.78270476, 0.07068334, 0.80061511,
        0.66090995, 0.40403670, 0.37639738, 0.31872702,
        0.10560548, 0.32295307, 0.71104409, 0.95057601,
        0.62568311, 0.82158469, 0.87822325, 0.34216374,
        0.42095343, 0.49155748, 0.04824981, 0.93577404,
        0.02006045, 0.52143329, 0.35735855, 0.22339355,
        0.21191254, 0.25463790, 0.00673706, 0.02776729,
        0.29688424, 0.28939652, 0.93429233, 0.54223604,
        0.24985107, 0.83891685, 0.16851543, 0.09681473,
        0.12913905, 0.41894106, 0.88119316, 0.56941667,
        0.98743163, 0.24583594, 0.26439969, 0.98900542,
        0.59552390, 0.10598290, 0.19145128, 0.82124177,
        0.16724271, 0.44599363, 0.59829451, 0.72605966,
        0.09989227, 0.82615394, 0.58065050, 0.11331605,
        0.28981000, 0.84587381, 0.07083202, 0.14833035,
        0.65867223, 0.59021865, 0.58735805, 0.59678862,
        0.70551718, 0.19207017, 0.73940653, 0.22106109,
        0.33934016, 0.77465068, 0.22509303, 0.12357820,
        0.94794034, 0.97312112, 0.73280797, 0.59965500,
        0.18524258, 0.11258899, 0.55591609, 0.46436632,
        0.21880912, 0.19875870, 0.38389680, 0.14392435,
        0.70625112, 0.93164951, 0.79722014, 0.48610288,
        0.72093904, 0.72137738, 0.27261254, 0.76680176,
        0.11663760, 0.18397960, 0.03195002, 0.82115076,
        0.73068862, 0.28732616, 0.61875003, 0.88276158,
        0.02675303, 0.93052378, 0.45810254, 0.80719106,
        0.78505935, 0.15465711, 0.81852908, 0.01035686,
        0.63759970, 0.57701143, 0.61182946, 0.81902549,
        0.64849716, 0.63775381, 0.33944463, 0.01088021,
        0.81885416, 0.06320171, 0.09684302, 0.04174445,
        0.93106984, 0.07546183, 0.24547596, 0.93751226,
        0.74065679, 0.54327627, 0.17024274, 0.94692311,
        0.09290775, 0.53920561, 0.72992514, 0.62150301,
        0.40669172, 0.06787872, 0.72004642, 0.39490120,
        0.98234857, 0.94828936, 0.74268101, 0.73370598,
        0.68092173, 0.37850705, 0.61021436, 0.26261629,
        0.52934261, 0.06334639, 0.76891534, 0.32289764,
        0.92373486, 0.42402109, 0.41378012, 0.10279785,
        0.67314394, 0.48186146, 0.50675380, 0.86822955,
        0.82499410, 0.15719373, 0.29668140, 0.92028725,
        0.95904319, 0.25983566, 0.75594963, 0.46969604,
        0.82638328, 0.56783068, 0.96105872, 0.43980714,
        0.98960801, 0.70075472, 0.15540090, 0.57160886,
        0.88793223, 0.57795871, 0.56514445, 0.65909586,
        0.69458952, 0.42359339, 0.09707922, 0.04027207,
        0.79641460, 0.55542973, 0.57159987, 0.41985797,
        0.61658945, 0.03278444, 0.63403447, 0.09048499,
        0.84939516, 0.04907535, 0.57921900, 0.96982613,
        0.96066375, 0.60938927, 0.98017393, 0.47613619,
        0.04483615, 0.35458106, 0.77925608, 0.09762995,
        0.17605426, 0.65475580, 0.49400027, 0.74430323,
        0.66834557, 0.55180554, 0.56149147, 0.17780739,
        0.45887371, 0.87113438, 0.34729137, 0.03621890,
        0.02752394, 0.58748568, 0.94949200, 0.01234387,
        0.22512224, 0.20421475, 0.30241591, 0.44287630,
        0.92693591, 0.85988589, 0.58523018, 0.75493725,
        0.67976038, 0.90210808, 0.16193264, 0.06854948,
        0.78065400, 0.56588785, 0.06676102, 0.42662219,
        0.12653993, 0.18016388, 0.74432183, 0.80186216,
        0.61353588, 0.30734192, 0.60950496, 0.73033964,
        0.45933113, 0.95340344, 0.95873238, 0.22091518,
        0.41664395, 0.89282994, 0.12649949, 0.94538995,
        0.38797159, 0.21194355, 0.93976699, 0.13237574,
        0.17614998, 0.63638084, 0.74515463, 0.15821088,
        0.26233025, 0.97151094, 0.84639784, 0.96858076,
        0.12372874, 0.00061914, 0.47989416, 0.46585169,
        0.93181998, 0.24168970, 0.51493176, 0.84527806,
        0.71583991, 0.47779283, 0.74898920, 0.14752760,
        0.50176804, 0.23792488, 0.36169898, 0.07560302,
        0.38701148, 0.76247368, 0.20033977, 0.48230152,
        0.30565115, 0.22688719, 0.31492229, 0.73908020,
        0.63944999, 0.63692535, 0.36776983, 0.99915443,
        0.37796898, 0.57700454, 0.19073928, 0.35272975,
        0.47523137, 0.86415822, 0.14259931, 0.86897617,
        0.87083832, 0.09469065, 0.01176569, 0.66519020,
        0.53688186, 0.57907948, 0.92104488, 0.53224148,
        0.94279853, 0.66933028, 0.76264173, 0.00846143,
        0.17787411, 0.27029984, 0.94069575, 0.97091936,
        0.34419143, 0.80513430, 0.97102144, 0.56356255,
        0.96426302, 0.36658938, 0.83537716, 0.99772803,
        0.44309853, 0.82985523, 0.10590215, 0.26874156,
        0.99451632, 0.40830606, 0.55523556, 0.66017859,
        0.55543373, 0.33966445, 0.68147221, 0.15953739,
        0.70994904, 0.34768995, 0.26252758, 0.61505059,
        0.73006930, 0.19949312, 0.20781777, 0.56998090,
        0.08808883, 0.90775056, 0.64990724, 0.85463078,
        0.57091962, 0.37328744, 0.94231607, 0.48375077,
        0.51243150, 0.08293697, 0.84244579, 0.71510894,
        0.16874849, 0.98483478, 0.79377902, 0.71630545,
        0.02827830, 0.05768694, 0.19752560, 0.91946121,
        0.75047528, 0.77643189, 0.55484145, 0.09883586,
        0.95207175, 0.61484315, 0.65478232, 0.89697994,
        0.81336748, 0.68487048, 0.30860410, 0.69941932,
        0.81105303, 0.30717890, 0.98674485, 0.61447425,
        0.69822731, 0.75686959, 0.52146685, 0.40302938,
        0.26923451, 0.51424179, 0.65125432, 0.35501958,
        0.51128504, 0.62502966, 0.93869369, 0.04485744,
        0.46558787, 0.36337906, 0.06694895, 0.56433501,
        0.11381991, 0.25193077, 0.98502529, 0.05704914,
        0.42741233, 0.94695681, 0.34237149, 0.21235143,
        0.38026753, 0.87707973, 0.19586441, 0.12177076,
        0.50809963, 0.75425738, 0.73740277, 0.95442052,
        0.30532292, 0.28454304, 0.11094620, 0.28705514,
        0.60379470, 0.82317726, 0.68476054, 0.19807496,
        0.62396085, 0.93379787, 0.54316971, 0.63767898,
        0.48464992, 0.62082514, 0.88571107, 0.53376650,
        0.33199652, 0.73353233, 0.40077416, 0.74618470,
        0.59866563, 0.21305606, 0.12555324, 0.99799893,
        0.55033241, 0.03249085, 0.26086445, 0.98521994,
        0.99166855, 0.53523486, 0.69955169, 0.04899369,
        0.23795922, 0.47763494, 0.76727401, 0.33971988,
        0.13467868, 0.61420180, 0.15563938, 0.55256845,
        0.26988188, 0.13261020, 0.27974280, 0.11176598,
        0.32525126, 0.88784146, 0.26752581, 0.03067154,
        0.60569129, 0.02002373, 0.48760334, 0.62073825,
        0.21474893, 0.76444057, 0.55800774, 0.73889036,
        0.29518644, 0.94996021, 0.56444047, 0.47058584,
        0.43366718, 0.85572272, 0.90300854, 0.59503714,
        0.65801756, 0.56853684, 0.58558048, 0.72015027,
        0.17025921, 0.30271306, 0.53116499, 0.97653227,
        0.51964288, 0.52717848, 0.05840294, 0.52634715,
        0.29470665, 0.99334131, 0.65047692, 0.47785087,
        0.90506666, 0.67078885, 0.90046675, 0.32475029,
        0.34752749, 0.91294030, 0.03475684, 0.26864050,
        0.50324954, 0.46955497, 0.53413073, 0.84181129,
        0.36085900, 0.59277558, 0.88209431, 0.25836241,
        0.70103928, 0.02857411, 0.36042473, 0.56857452,
        0.45256708, 0.61420176, 0.18950828, 0.57047725,
        0.27502452, 0.76338308, 0.54628702, 0.97671683,
        0.91241649, 0.87801976, 0.90878537, 0.53572628,
        0.28748983, 0.38151063, 0.53979463, 0.02287989,
        0.16685784, 0.29065976, 0.90010275, 0.22090120,
        0.00914414, 0.02322095, 0.25122691, 0.39070380,
        0.52512120, 0.72430885, 0.72957361, 0.97871460,
        0.93695260, 0.21384469, 0.68111323, 0.93152877,
        0.38167531, 0.64671057, 0.99357667, 0.81439462,
        0.18172161, 0.34157997, 0.14163516, 0.97008374,
        0.00017817, 0.17492667, 0.89017036, 0.10573359,
        0.01900931, 0.16774126, 0.79037446, 0.84010306,
        0.47519226, 0.00439313, 0.18381522, 0.84613238,
        0.75610369, 0.38004291, 0.12868142, 0.35629285,
        0.80828631, 0.28274608, 0.44106362, 0.73265737,
        0.61325191, 0.24187840, 0.97955674, 0.93618438,
        0.96051047, 0.23422243, 0.97520706, 0.82584169,
        0.88025727, 0.35319169, 0.11022647, 0.48966716,
        0.33862352, 0.46629508, 0.35234246, 0.99066635,
        0.99262152, 0.00977917, 0.61749715, 0.22281960,
        0.71707526, 0.87362648, 0.91055938, 0.47073659,
        0.88101976, 0.21494194, 0.33205552, 0.54351819,
        0.55835019, 0.01768484, 0.02116836, 0.70469912,
        0.76899386, 0.64696939, 0.40084197, 0.59803212,
        0.52970593, 0.89719532, 0.87168575, 0.35151884,
        0.56087250, 0.38735172, 0.10494279, 0.41009167,
        0.74723117, 0.32829241, 0.92508072, 0.08944341,
        0.61823771, 0.95199810, 0.38566778, 0.45387474,
        0.14874216, 0.06920534, 0.16466161, 0.57534195,
        0.72012502, 0.22840780, 0.64040413, 0.72252710,
        0.46071354, 0.95938459, 0.15282101, 0.25416612,
        0.27624054, 0.40343682, 0.21556083, 0.10719734,
        0.01178395, 0.81544681, 0.61108854, 0.58873211,
        0.08313659, 0.31389776, 0.26683639, 0.17408690,
        0.19860426, 0.54852056, 0.45089482, 0.29739356,
        0.06490634, 0.94512628, 0.75476861, 0.79302202,
        0.91709407, 0.44093711, 0.42285809, 0.87353064,
        0.05154859, 0.05673061, 0.03360053, 0.47314265,
        0.14352713, 0.86919501, 0.89407749, 0.71384359,
        0.43505102, 0.76105734, 0.48072900, 0.26590561,
        0.23636561, 0.53526685, 0.43621137, 0.70461497,
        0.04695302, 0.29312615, 0.47657411, 0.47776949,
        0.67893515, 0.74761854, 0.19647090, 0.90858326,
        0.65050969, 0.78866488, 0.56645663, 0.28301728,
        0.21439215, 0.23534408, 0.99123621, 0.33798052,
        0.57132079, 0.13509136, 0.23913264, 0.98822790,
        0.12259069, 0.59413715, 0.98916346, 0.15804781,
        0.53868433, 0.82989573, 0.31032958, 0.52338512,
        0.43014882, 0.80809309, 0.58102790, 0.41232677,
        0.72325580, 0.15152519, 0.61332742, 0.69908457,
        0.68902723, 0.40867770, 0.56938072, 0.30977628,
        0.75155389, 0.77055871, 0.24496359, 0.00515177,
        0.68565391, 0.04478322, 0.74595021, 0.44720965,
        0.25587623, 0.42443591, 0.05974449, 0.20046287,
        0.30343490, 0.90622420, 0.64120083, 0.52238185,
        0.11133412, 0.43655075, 0.76620214, 0.36598683,
        0.67400905, 0.89241105, 0.69407209, 0.64427034,
        0.18430072, 0.92961135, 0.37992458, 0.41103806,
        0.99307206, 0.62659181, 0.44814843, 0.07694981,
    ],
}, {
    output0: [],
})).WithMultinomialDistributionTolerance(0.025).DisableLifeTimeVariation()
