/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <linux/bpf.h>
#include <stdbool.h>
#include <stdint.h>
#include <bpf_helpers.h>

/* Assume max of 1024 CPUs */
DEFINE_BPF_MAP(cpu_pid_map, ARRAY, int, uint32_t, 1024)

struct switch_args {
    unsigned long long ignore;
    char prev_comm[16];
    int prev_pid;
    int prev_prio;
    long long prev_state;
    char next_comm[16];
    int next_pid;
    int next_prio;
};

DEFINE_BPF_PROG("tracepoint/sched/sched_switch", AID_ROOT, AID_ROOT, tp_sched_switch)
(struct switch_args* args) {
    int key;
    uint32_t val;

    key = bpf_get_smp_processor_id();
    val = args->next_pid;

    bpf_cpu_pid_map_update_elem(&key, &val, BPF_ANY);
    return 0;
}


struct wakeup_args {
    unsigned long long ignore;
    char comm[16];
    int pid;
    int prio;
    int success;
    int target_cpu;
};

DEFINE_BPF_PROG_KVER("tracepoint/sched/sched_wakeup", AID_ROOT, AID_ROOT, tp_sched_wakeup, KVER_INF)
(struct wakeup_args* args) {
    return 0;
}

LICENSE("GPL");
