/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2022 Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef AIS_MAIN_H
#define AIS_MAIN_H

#include <linux/platform_device.h>
#include <linux/i2c.h>
#include <linux/component.h>

extern struct platform_driver cam_sync_driver;
extern struct platform_driver cam_smmu_driver;
extern struct platform_driver cam_cpas_driver;
extern struct platform_driver cam_cdm_intf_driver;
extern struct platform_driver cam_hw_cdm_driver;
#ifdef CONFIG_SPECTRA_ISP
extern struct platform_driver ais_ife_csid17x_driver;
extern struct platform_driver ais_ife_csid_lite_driver;
extern struct platform_driver ais_vfe_driver;
extern struct platform_driver ife_driver;
extern struct platform_driver cam_ife_csid17x_driver;
extern struct platform_driver cam_ife_csid_lite_driver;
extern struct platform_driver cam_vfe_driver;
extern struct platform_driver isp_driver;
#endif
#ifdef CONFIG_SPECTRA_SENSOR
extern struct platform_driver cam_res_mgr_driver;
extern struct platform_driver cci_driver;
extern struct platform_driver csiphy_driver;
#ifdef CONFIG_MSM_AIS_ACTUATOR
extern struct platform_driver cam_actuator_platform_driver;
#endif
extern struct platform_driver cam_sensor_platform_driver;
#ifdef CONFIG_MSM_AIS_EEPROM
extern struct platform_driver cam_eeprom_platform_driver;
#endif
#ifdef CONFIG_MSM_AIS_OIS
extern struct platform_driver cam_ois_platform_driver;
#endif
#ifdef CONFIG_MSM_AIS_ACTUATOR
extern struct i2c_driver cam_actuator_i2c_driver;
#endif
extern struct i2c_driver cam_sensor_i2c_driver;
#ifdef CONFIG_MSM_AIS_EEPROM
extern struct i2c_driver cam_eeprom_i2c_driver;
#endif
#ifdef CONFIG_MSM_AIS_OIS
extern struct i2c_driver cam_ois_i2c_driver;
#endif
#ifdef CONFIG_MSM_AIS_FLASH
extern struct i2c_driver cam_flash_i2c_driver;
#if IS_REACHABLE(CONFIG_LEDS_QPNP_FLASH_V2) || \
	IS_REACHABLE(CONFIG_LEDS_QTI_FLASH)
extern struct platform_driver cam_flash_platform_driver;
#endif
#endif
#endif

#ifdef CONFIG_SPECTRA_ICP
extern struct platform_driver cam_a5_driver;
extern struct platform_driver cam_ipe_driver;
extern struct platform_driver cam_bps_driver;
extern struct platform_driver cam_icp_driver;
#endif
#ifdef CONFIG_SPECTRA_JPEG
extern struct platform_driver cam_jpeg_enc_driver;
extern struct platform_driver cam_jpeg_dma_driver;
extern struct platform_driver jpeg_driver;
#endif
#ifdef CONFIG_SPECTRA_FD
extern struct platform_driver cam_fd_hw_driver;
extern struct platform_driver cam_fd_driver;
#endif
#ifdef CONFIG_SPECTRA_LRME
extern struct platform_driver cam_lrme_hw_driver;
extern struct platform_driver cam_lrme_driver;
#endif

/*
 * Drivers to be bound by component framework in this order with
 * CRM as master
 */
static struct platform_driver *const cam_component_platform_drivers[] = {
/* BASE */
	&cam_sync_driver,
	&cam_smmu_driver,
	&cam_cpas_driver,
	&cam_cdm_intf_driver,
	&cam_hw_cdm_driver,
#ifdef CONFIG_SPECTRA_ISP
	&ais_ife_csid17x_driver,
	&ais_ife_csid_lite_driver,
	&ais_vfe_driver,
	&ife_driver,
	&cam_ife_csid17x_driver,
	&cam_ife_csid_lite_driver,
	&cam_vfe_driver,
	&isp_driver,
#endif
#ifdef CONFIG_SPECTRA_SENSOR
	&cam_res_mgr_driver,
	&cci_driver,
	&csiphy_driver,
#ifdef CONFIG_MSM_AIS_ACTUATOR
	&cam_actuator_platform_driver,
#endif
	&cam_sensor_platform_driver,
#ifdef CONFIG_MSM_AIS_EEPROM
	&cam_eeprom_platform_driver,
#endif
#ifdef CONFIG_MSM_AIS_OIS
	&cam_ois_platform_driver,
#endif
#ifdef CONFIG_MSM_AIS_FLASH
#if IS_REACHABLE(CONFIG_LEDS_QPNP_FLASH_V2) || \
	IS_REACHABLE(CONFIG_LEDS_QTI_FLASH)
	&cam_flash_platform_driver,
#endif
#endif
#endif
#ifdef CONFIG_SPECTRA_ICP
	&cam_a5_driver,
	&cam_ipe_driver,
	&cam_bps_driver,
	&cam_icp_driver,
#endif
#ifdef CONFIG_SPECTRA_JPEG
	&cam_jpeg_enc_driver,
	&cam_jpeg_dma_driver,
	&jpeg_driver,
#endif
#ifdef CONFIG_SPECTRA_FD
	&cam_fd_hw_driver,
	&cam_fd_driver,
#endif
#ifdef CONFIG_SPECTRA_LRME
	&cam_lrme_hw_driver,
	&cam_lrme_driver,
#endif
};


static struct i2c_driver *const cam_component_i2c_drivers[] = {
#ifdef CONFIG_MSM_AIS_ACTUATOR
	&cam_actuator_i2c_driver,
#endif
#ifdef CONFIG_MSM_AIS_FLASH
	&cam_flash_i2c_driver,
#endif
#ifdef CONFIG_MSM_AIS_OIS
	&cam_ois_i2c_driver,
#endif
#ifdef CONFIG_MSM_AIS_EEPROM
	&cam_eeprom_i2c_driver,
#endif
#ifdef CONFIG_SPECTRA_SENSOR
	&cam_sensor_i2c_driver,
#endif
};

#endif /* AIS_MAIN_H */
