/* Copyright (c) 2017-2018, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _CAM_LRME_HW_REG_H_
#define _CAM_LRME_HW_REG_H_

#include "cam_lrme_hw_core.h"

static struct cam_lrme_hw_info cam_lrme10_hw_info = {
	.clc_reg = {
		.clc_hw_version                 = 0x00000000,
		.clc_hw_status                  = 0x00000004,
		.clc_hw_status_dbg              = 0x00000008,
		.clc_module_cfg                 = 0x00000060,
		.clc_moduleformat               = 0x000000A8,
		.clc_rangestep                  = 0x00000068,
		.clc_offset                     = 0x0000006C,
		.clc_maxallowedsad              = 0x00000070,
		.clc_minallowedtarmad           = 0x00000074,
		.clc_meaningfulsaddiff          = 0x00000078,
		.clc_minsaddiffdenom            = 0x0000007C,
		.clc_robustnessmeasuredistmap_0 = 0x00000080,
		.clc_robustnessmeasuredistmap_1 = 0x00000084,
		.clc_robustnessmeasuredistmap_2 = 0x00000088,
		.clc_robustnessmeasuredistmap_3 = 0x0000008C,
		.clc_robustnessmeasuredistmap_4 = 0x00000090,
		.clc_robustnessmeasuredistmap_5 = 0x00000094,
		.clc_robustnessmeasuredistmap_6 = 0x00000098,
		.clc_robustnessmeasuredistmap_7 = 0x0000009C,
		.clc_ds_crop_horizontal         = 0x000000A0,
		.clc_ds_crop_vertical           = 0x000000A4,
		.clc_tar_pd_unpacker            = 0x000000AC,
		.clc_ref_pd_unpacker            = 0x000000B0,
		.clc_sw_override                = 0x000000B4,
		.clc_tar_height                 = 0x000000B8,
		.clc_ref_height                 = 0x000000BC,
		.clc_test_bus_ctrl              = 0x000001F8,
		.clc_spare                      = 0x000001FC,
	},
	.bus_rd_reg = {
		.common_reg = {
			.hw_version     = 0x00000200,
			.hw_capability  = 0x00000204,
			.sw_reset       = 0x00000208,
			.cgc_override   = 0x0000020C,
			.irq_mask       = 0x00000210,
			.irq_clear      = 0x00000214,
			.irq_cmd        = 0x00000218,
			.irq_status     = 0x0000021C,
			.cmd            = 0x00000220,
			.irq_set        = 0x00000224,
			.misr_reset     = 0x0000022C,
			.security_cfg   = 0x00000230,
			.pwr_iso_cfg    = 0x00000234,
			.pwr_iso_seed   = 0x00000238,
			.test_bus_ctrl  = 0x00000248,
			.spare          = 0x0000024C,
		},
		.bus_client_reg = {
			/* bus client 0 */
			{
				.core_cfg                = 0x00000250,
				.ccif_meta_data          = 0x00000254,
				.addr_image              = 0x00000258,
				.rd_buffer_size          = 0x0000025C,
				.rd_stride               = 0x00000260,
				.unpack_cfg_0            = 0x00000264,
				.latency_buff_allocation = 0x00000278,
				.burst_limit_cfg         = 0x00000280,
				.misr_cfg_0              = 0x00000284,
				.misr_cfg_1              = 0x00000288,
				.misr_rd_val             = 0x0000028C,
				.debug_status_cfg        = 0x00000290,
				.debug_status_0          = 0x00000294,
				.debug_status_1          = 0x00000298,
			},
			/* bus client 1 */
			{
				.core_cfg                = 0x000002F0,
				.ccif_meta_data          = 0x000002F4,
				.addr_image              = 0x000002F8,
				.rd_buffer_size          = 0x000002FC,
				.rd_stride               = 0x00000300,
				.unpack_cfg_0            = 0x00000304,
				.latency_buff_allocation = 0x00000318,
				.burst_limit_cfg         = 0x00000320,
				.misr_cfg_0              = 0x00000324,
				.misr_cfg_1              = 0x00000328,
				.misr_rd_val             = 0x0000032C,
				.debug_status_cfg        = 0x00000330,
				.debug_status_0          = 0x00000334,
				.debug_status_1          = 0x00000338,
			},
		},
	},
	.bus_wr_reg = {
		.common_reg = {
			.hw_version        = 0x00000500,
			.hw_capability     = 0x00000504,
			.sw_reset          = 0x00000508,
			.cgc_override      = 0x0000050C,
			.misr_reset        = 0x000005C8,
			.pwr_iso_cfg       = 0x000005CC,
			.test_bus_ctrl     = 0x0000061C,
			.composite_mask_0  = 0x00000510,
			.irq_mask_0        = 0x00000544,
			.irq_mask_1        = 0x00000548,
			.irq_clear_0       = 0x00000550,
			.irq_clear_1       = 0x00000554,
			.irq_status_0      = 0x0000055C,
			.irq_status_1      = 0x00000560,
			.irq_cmd           = 0x00000568,
			.irq_set_0         = 0x000005BC,
			.irq_set_1         = 0x000005C0,
			.addr_fifo_status  = 0x000005A8,
			.frame_header_cfg0 = 0x000005AC,
			.frame_header_cfg1 = 0x000005B0,
			.spare             = 0x00000620,
		},
		.bus_client_reg = {
			/* bus client 0 */
			{
				.status_0                  = 0x00000700,
				.status_1                  = 0x00000704,
				.cfg                       = 0x00000708,
				.addr_frame_header         = 0x0000070C,
				.frame_header_cfg          = 0x00000710,
				.addr_image                = 0x00000714,
				.addr_image_offset         = 0x00000718,
				.buffer_width_cfg          = 0x0000071C,
				.buffer_height_cfg         = 0x00000720,
				.packer_cfg                = 0x00000724,
				.wr_stride                 = 0x00000728,
				.irq_subsample_cfg_period  = 0x00000748,
				.irq_subsample_cfg_pattern = 0x0000074C,
				.burst_limit_cfg           = 0x0000075C,
				.misr_cfg                  = 0x00000760,
				.misr_rd_word_sel          = 0x00000764,
				.misr_val                  = 0x00000768,
				.debug_status_cfg          = 0x0000076C,
				.debug_status_0            = 0x00000770,
				.debug_status_1            = 0x00000774,
			},
			/* bus client 1 */
			{
				.status_0                  = 0x00000800,
				.status_1                  = 0x00000804,
				.cfg                       = 0x00000808,
				.addr_frame_header         = 0x0000080C,
				.frame_header_cfg          = 0x00000810,
				.addr_image                = 0x00000814,
				.addr_image_offset         = 0x00000818,
				.buffer_width_cfg          = 0x0000081C,
				.buffer_height_cfg         = 0x00000820,
				.packer_cfg                = 0x00000824,
				.wr_stride                 = 0x00000828,
				.irq_subsample_cfg_period  = 0x00000848,
				.irq_subsample_cfg_pattern = 0x0000084C,
				.burst_limit_cfg           = 0x0000085C,
				.misr_cfg                  = 0x00000860,
				.misr_rd_word_sel          = 0x00000864,
				.misr_val                  = 0x00000868,
				.debug_status_cfg          = 0x0000086C,
				.debug_status_0            = 0x00000870,
				.debug_status_1            = 0x00000874,
			},
		},
	},
	.titan_reg = {
		.top_hw_version        = 0x00000900,
		.top_titan_version     = 0x00000904,
		.top_rst_cmd           = 0x00000908,
		.top_core_clk_cfg      = 0x00000920,
		.top_irq_status        = 0x0000090C,
		.top_irq_mask          = 0x00000910,
		.top_irq_clear         = 0x00000914,
		.top_irq_set           = 0x00000918,
		.top_irq_cmd           = 0x0000091C,
		.top_violation_status  = 0x00000924,
		.top_spare             = 0x000009FC,
	},
};

#endif /* _CAM_LRME_HW_REG_H_ */
