/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2016,2019, The Linux Foundation. All rights reserved.
 */

struct adreno_critical_fixup {
	unsigned int lo_offset;
	unsigned int hi_offset;
	int buffer;
	uint64_t mem_offset;
};

static unsigned int _a5xx_critical_pkts[] = {
	0x400E0601, /* [0x0000] == TYPE4 == */
	0x00000002, /* [0x0001] A5X_HLSQ_MODE_CNTL (0x0E06)*/
	0x40E78A01, /* [0x0002] == TYPE4 == */
	0x000FFFFF, /* [0x0003] A5X_HLSQ_UPDATE_CNTL_CTX_0 (0xE78A)*/
	0x48E78401, /* [0x0004] == TYPE4 == */
	0x00000005, /* [0x0005] A5X_HLSQ_CNTL_0_CTX_0 (0xE784)*/
	0x40E78501, /* [0x0006] == TYPE4 == */
	0x00000009, /* [0x0007] A5X_HLSQ_CNTL_1_CTX_0 (0xE785)*/
	0x48E78B85, /* [0x0008] == TYPE4 == */
	0x00000001, /* [0x0009] A5X_HLSQ_VS_CONFIG_CTX_0 (0xE78B)*/
	0x00002085, /* [0x000A] A5X_HLSQ_PS_CONFIG_CTX_0 (0xE78C)*/
	0x00002084, /* [0x000B] A5X_HLSQ_HS_CONFIG_CTX_0 (0xE78D)*/
	0x00002084, /* [0x000C] A5X_HLSQ_DS_CONFIG_CTX_0 (0xE78E)*/
	0x00002084, /* [0x000D] A5X_HLSQ_GS_CONFIG_CTX_0 (0xE78F)*/
	0x40E58485, /* [0x000E] == TYPE4 == */
	0x00000001, /* [0x000F] A5X_SP_VS_CONFIG_CTX_0 (0xE584)*/
	0x00002085, /* [0x0010] A5X_SP_PS_CONFIG_CTX_0 (0xE585)*/
	0x00002084, /* [0x0011] A5X_SP_HS_CONFIG_CTX_0 (0xE586)*/
	0x00002084, /* [0x0012] A5X_SP_DS_CONFIG_CTX_0 (0xE587)*/
	0x00002084, /* [0x0013] A5X_SP_GS_CONFIG_CTX_0 (0xE588)*/
	0x40E79101, /* [0x0014] == TYPE4 == */
	0x00000004, /* [0x0015] A5X_HLSQ_VS_CNTL_CTX_0 (0xE791)*/
	0x40E79201, /* [0x0016] == TYPE4 == */
	0x00000002, /* [0x0017] A5X_HLSQ_PS_CNTL_CTX_0 (0xE792)*/
	0x48E58001, /* [0x0018] == TYPE4 == */
	0x00000010, /* [0x0019] A5X_SP_SP_CNTL_CTX_0 (0xE580)*/
	0x70B00043, /* [0x001A] == TYPE7: LOAD_STATE (30) == */
	0x00A00000, /* [0x001B] */
	0x00000000, /* [0x001C] */
	0x00000000, /* [0x001D] */
	0x20020003, /* [0x001E] */
	0x56D81803, /* [0x001F] */
	0x00000003, /* [0x0020] */
	0x20150000, /* [0x0021] */
	0x00000000, /* [0x0022] */
	0x00000200, /* [0x0023] */
	0x00000000, /* [0x0024] */
	0x201100F4, /* [0x0025] */
	0x00000000, /* [0x0026] */
	0x00000500, /* [0x0027] */
	0x00000C21, /* [0x0028] */
	0x20154004, /* [0x0029] */
	0x00000C20, /* [0x002A] */
	0x20154003, /* [0x002B] */
	0x00000C23, /* [0x002C] */
	0x20154008, /* [0x002D] */
	0x00000C22, /* [0x002E] */
	0x20156007, /* [0x002F] */
	0x00000000, /* [0x0030] */
	0x20554005, /* [0x0031] */
	0x3F800000, /* [0x0032] */
	0x20554006, /* [0x0033] */
	0x00000000, /* [0x0034] */
	0x03000000, /* [0x0035] */
	0x20050000, /* [0x0036] */
	0x46F00009, /* [0x0037] */
	0x201F0000, /* [0x0038] */
	0x4398000A, /* [0x0039] */
	0x201F0009, /* [0x003A] */
	0x43980809, /* [0x003B] */
	0x20180009, /* [0x003C] */
	0x46100809, /* [0x003D] */
	0x00091014, /* [0x003E] */
	0x62050009, /* [0x003F] */
	0x00000000, /* [0x0040] */
	0x00000500, /* [0x0041] */
	0x04800006, /* [0x0042] */
	0xC2C61300, /* [0x0043] */
	0x0280000E, /* [0x0044] */
	0xC2C61310, /* [0x0045] */
	0x00000000, /* [0x0046] */
	0x04800000, /* [0x0047] */
	0x00000000, /* [0x0048] */
	0x05000000, /* [0x0049] */
	0x00000000, /* [0x004A] */
	0x00000000, /* [0x004B] */
	0x00000000, /* [0x004C] */
	0x00000000, /* [0x004D] */
	0x00000000, /* [0x004E] */
	0x00000000, /* [0x004F] */
	0x00000000, /* [0x0050] */
	0x00000000, /* [0x0051] */
	0x00000000, /* [0x0052] */
	0x00000000, /* [0x0053] */
	0x00000000, /* [0x0054] */
	0x00000000, /* [0x0055] */
	0x00000000, /* [0x0056] */
	0x00000000, /* [0x0057] */
	0x00000000, /* [0x0058] */
	0x00000000, /* [0x0059] */
	0x00000000, /* [0x005A] */
	0x00000000, /* [0x005B] */
	0x00000000, /* [0x005C] */
	0x00000000, /* [0x005D] */
	0x70B00023, /* [0x005E] == TYPE7: LOAD_STATE (30) == */
	0x00700000, /* [0x005F] */
	0x00000000, /* [0x0060] */
	0x00000000, /* [0x0061] */
	0x00000000, /* [0x0062] */
	0x03000000, /* [0x0063] */
	0x00000000, /* [0x0064] */
	0x00000000, /* [0x0065] */
	0x00000000, /* [0x0066] */
	0x00000000, /* [0x0067] */
	0x00000000, /* [0x0068] */
	0x00000000, /* [0x0069] */
	0x00000000, /* [0x006A] */
	0x00000000, /* [0x006B] */
	0x00000000, /* [0x006C] */
	0x00000000, /* [0x006D] */
	0x00000000, /* [0x006E] */
	0x00000000, /* [0x006F] */
	0x00000000, /* [0x0070] */
	0x00000000, /* [0x0071] */
	0x00000000, /* [0x0072] */
	0x00000000, /* [0x0073] */
	0x00000000, /* [0x0074] */
	0x00000000, /* [0x0075] */
	0x00000000, /* [0x0076] */
	0x00000000, /* [0x0077] */
	0x00000000, /* [0x0078] */
	0x00000000, /* [0x0079] */
	0x00000000, /* [0x007A] */
	0x00000000, /* [0x007B] */
	0x00000000, /* [0x007C] */
	0x00000000, /* [0x007D] */
	0x00000000, /* [0x007E] */
	0x00000000, /* [0x007F] */
	0x00000000, /* [0x0080] */
	0x00000000, /* [0x0081] */
	0x70B08003, /* [0x0082] == TYPE7: LOAD_STATE (30) == */
	0x00620000, /* [0x0083] */
	0x00000000, /* [0x0084] */
	0x00000000, /* [0x0085] */
	0x70B08003, /* [0x0086] == TYPE7: LOAD_STATE (30) == */
	0x01220008, /* [0x0087] */
	0x00000000, /* [0x0088] */
	0x00000000, /* [0x0089] */
	0x70B0000B, /* [0x008A] == TYPE7: LOAD_STATE (30) == */
	0x01180000, /* [0x008B] */
	0x00000001, /* [0x008C] */
	0x00000000, /* [0x008D] */
	0x00000000, /* [0x008E] */
	0x00000000, /* [0x008F] */
	0x00000000, /* [0x0090] */
	0x00000000, /* [0x0091] */
	0x00000000, /* [0x0092] */
	0x00000000, /* [0x0093] */
	0x00000000, /* [0x0094] */
	0x01400000, /* [0x0095] */
	0x70460001, /* [0x0096] == TYPE7: EVENT_WRITE (46) == */
	0x00000019, /* [0x0097] */
	0x70460004, /* [0x0098] == TYPE7: EVENT_WRITE (46) == */
	0x0000001D, /* [0x0099] */
	0x00000000, /* [0x009A] */
	0x00000000, /* [0x009B] */
	0x00000001, /* [0x009C] */
	0x70460004, /* [0x009D] == TYPE7: EVENT_WRITE (46) == */
	0x0000001C, /* [0x009E] */
	0x00000000, /* [0x009F] */
	0x00000000, /* [0x00A0] */
	0x00000001, /* [0x00A1] */
	0x480E9185, /* [0x00A2] == TYPE4 == */
	0x00000000, /* [0x00A3] A5X_UCHE_CACHE_INVALIDATE_MIN_LO (0x0E91)*/
	0x00000000, /* [0x00A4] A5X_UCHE_CACHE_INVALIDATE_MIN_HI (0x0E92)*/
	0x00000000, /* [0x00A5] A5X_UCHE_CACHE_INVALIDATE_MAX_LO (0x0E93)*/
	0x00000000, /* [0x00A6] A5X_UCHE_CACHE_INVALIDATE_MAX_HI (0x0E94)*/
	0x00000012, /* [0x00A7] A5X_UCHE_CACHE_INVALIDATE (0x0E95)*/
	0x70268000, /* [0x00A8] == TYPE7: WAIT_FOR_IDLE (26) == */
	0x40E78A01, /* [0x00A9] == TYPE4 == */
	0x000FFFFF, /* [0x00AA] A5X_HLSQ_UPDATE_CNTL_CTX_0 (0xE78A)*/
	0x70D08003, /* [0x00AB] == TYPE7: PERFCOUNTER_ACTION (50) == */
	0x00000000, /* [0x00AC] */
	0x00000000, /* [0x00AD] */
	0x00000000, /* [0x00AE] */
	0x70D08003, /* [0x00AF] == TYPE7: PERFCOUNTER_ACTION (50) == */
	0x00000010, /* [0x00B0] */
	0x00000000, /* [0x00B1] */
	0x00000000, /* [0x00B2] */
	0x70268000, /* [0x00B3] == TYPE7: WAIT_FOR_IDLE (26) == */
	0x48E38C01, /* [0x00B4] == TYPE4 == */
	0xFFFFFFFF, /* [0x00B5] A5X_PC_RESTART_INDEX_CTX_0 (0xE38C)*/
	0x40E38801, /* [0x00B6] == TYPE4 == */
	0x00000012, /* [0x00B7] A5X_PC_RASTER_CNTL_CTX_0 (0xE388)*/
	0x48E09102, /* [0x00B8] == TYPE4 == */
	0xFFC00010, /* [0x00B9] A5X_GRAS_SU_POINT_MINMAX_CTX_0 (0xE091)*/
	0x00000008, /* [0x00BA] A5X_GRAS_SU_POINT_SIZE_CTX_0 (0xE092)*/
	0x40E09901, /* [0x00BB] == TYPE4 == */
	0x00000000, /* [0x00BC] A5X_GRAS_SU_CONSERVATIVE_RAS_CNTL_CTX_0
		     * (0xE099)
		     */
	0x48E0A401, /* [0x00BD] == TYPE4 == */
	0x00000000, /* [0x00BE] A5X_GRAS_SC_SCREEN_SCISSOR_CNTL_CTX_0 (0xE0A4)*/
	0x48E58A01, /* [0x00BF] == TYPE4 == */
	0x00000000, /* [0x00C0] A5X_SP_VS_CONFIG_MAX_CONST_CTX_0 (0xE58A)*/
	0x40E58B01, /* [0x00C1] == TYPE4 == */
	0x00000000, /* [0x00C2] A5X_SP_PS_CONFIG_MAX_CONST_CTX_0 (0xE58B)*/
	0x480CC601, /* [0x00C3] == TYPE4 == */
	0x00000044, /* [0x00C4] A5X_RB_MODE_CNTL (0x0CC6)*/
	0x400CC401, /* [0x00C5] == TYPE4 == */
	0x00100000, /* [0x00C6] A5X_RB_DBG_ECO_CNTL (0x0CC4)*/
	0x400E4201, /* [0x00C7] == TYPE4 == */
	0x00000000, /* [0x00C8] A5X_VFD_MODE_CNTL (0x0E42)*/
	0x480D0201, /* [0x00C9] == TYPE4 == */
	0x0000001F, /* [0x00CA] A5X_PC_MODE_CNTL (0x0D02)*/
	0x480EC201, /* [0x00CB] == TYPE4 == */
	0x0000001E, /* [0x00CC] A5X_SP_MODE_CNTL (0x0EC2)*/
	0x400EC001, /* [0x00CD] == TYPE4 == */
	0x40000800, /* [0x00CE] A5X_SP_DBG_ECO_CNTL (0x0EC0)*/
	0x400F0201, /* [0x00CF] == TYPE4 == */
	0x00000544, /* [0x00D0] A5X_TPL1_MODE_CNTL (0x0F02)*/
	0x400E0002, /* [0x00D1] == TYPE4 == */
	0x00000080, /* [0x00D2] A5X_HLSQ_TIMEOUT_THRESHOLD_0 (0x0E00)*/
	0x00000000, /* [0x00D3] A5X_HLSQ_TIMEOUT_THRESHOLD_1 (0x0E01)*/
	0x400E6001, /* [0x00D4] == TYPE4 == */
	0x00000400, /* [0x00D5] A5X_VPC_DBG_ECO_CNTL (0x0E60)*/
	0x400E0601, /* [0x00D6] == TYPE4 == */
	0x00000001, /* [0x00D7] A5X_HLSQ_MODE_CNTL (0x0E06)*/
	0x480E6201, /* [0x00D8] == TYPE4 == */
	0x00000000, /* [0x00D9] A5X_VPC_MODE_CNTL (0x0E62)*/
	0x70EC8005, /* [0x00DA] == TYPE7: SET_RENDER_MODE (6C) == */
	0x00000002, /* [0x00DB] */
	0x00000000, /* [0x00DC] */
	0x00000000, /* [0x00DD] */
	0x00000008, /* [0x00DE] */
	0x00000001, /* [0x00DF] */
	0x40E14001, /* [0x00E0] == TYPE4 == */
	0x00000204, /* [0x00E1] A5X_RB_CNTL_CTX_0 (0xE140)*/
	0x709D0001, /* [0x00E2] == TYPE7: SKIP_IB2_ENABLE_GLOBAL (1D) == */
	0x00000000, /* [0x00E3] */
	0x48E0EA02, /* [0x00E4] == TYPE4 == */
	0x00000000, /* [0x00E5] A5X_GRAS_SC_WINDOW_SCISSOR_TL_CTX_0 (0xE0EA)*/
	0x001F0073, /* [0x00E6] A5X_GRAS_SC_WINDOW_SCISSOR_BR_CTX_0 (0xE0EB)*/
	0x48E21102, /* [0x00E7] == TYPE4 == */
	0x00000000, /* [0x00E8] A5X_RB_RESOLVE_CNTL_1_CTX_0 (0xE211)*/
	0x00000000, /* [0x00E9] A5X_RB_RESOLVE_CNTL_2_CTX_0 (0xE212)*/
	0x480BC283, /* [0x00EA] == TYPE4 == */
	0x00000204, /* [0x00EB] UNKNOWN (0x0BC2)*/
	0x00000000, /* [0x00EC] UNKNOWN (0x0BC3)*/
	0x00000000, /* [0x00ED] UNKNOWN (0x0BC4)*/
	0x400BC502, /* [0x00EE] == TYPE4 == */
	0x00000000, /* [0x00EF] UNKNOWN (0x0BC5)*/
	0x00000000, /* [0x00F0] UNKNOWN (0x0BC6)*/
	0x480BD001, /* [0x00F1] == TYPE4 == */
	0x01100000, /* [0x00F2] UNKNOWN (0x0BD0)*/
	0x480BE002, /* [0x00F3] == TYPE4 == */
	0x00000000, /* [0x00F4] UNKNOWN (0x0BE0)*/
	0x00000000, /* [0x00F5] UNKNOWN (0x0BE1)*/
	0x480C0001, /* [0x00F6] == TYPE4 == */
	0x00000020, /* [0x00F7] A5X_VSC_PIPE_DATA_LENGTH_0 (0x0C00)*/
	0x48E3B001, /* [0x00F8] == TYPE4 == */
	0x00000003, /* [0x00F9] A5X_PC_POWER_CNTL_CTX_0 (0xE3B0)*/
	0x48E4F001, /* [0x00FA] == TYPE4 == */
	0x00000003, /* [0x00FB] A5X_VFD_POWER_CNTL_CTX_0 (0xE4F0)*/
	0x480E6201, /* [0x00FC] == TYPE4 == */
	0x00000001, /* [0x00FD] A5X_VPC_MODE_CNTL (0x0E62)*/
	0x70460001, /* [0x00FE] == TYPE7: EVENT_WRITE (46) == */
	0x0000002C, /* [0x00FF] */
	0x40E1D001, /* [0x0100] == TYPE4 == */
	0x00000000, /* [0x0101] A5X_RB_WINDOW_OFFSET_CTX_0 (0xE1D0)*/
	0x70BF8003, /* [0x0102] == TYPE7: INDIRECT_BUFFER_PFE (3F) == */
	0x00000000, /* [0x0103] */
	0x00000000, /* [0x0104] */
	0x000000A0, /* [0x0105] */
	0x70460001, /* [0x0106] == TYPE7: EVENT_WRITE (46) == */
	0x0000002D, /* [0x0107] */
	0x70460004, /* [0x0108] == TYPE7: EVENT_WRITE (46) == */
	0x00000004, /* [0x0109] */
	0x00000000, /* [0x010A] */
	0x00000000, /* [0x010B] */
	0x00000000, /* [0x010C] */
	0x70268000, /* [0x010D] == TYPE7: WAIT_FOR_IDLE (26) == */
	0x480E6201, /* [0x010E] == TYPE4 == */
	0x00000000, /* [0x010F] A5X_VPC_MODE_CNTL (0x0E62)*/
	0x48E3B001, /* [0x0110] == TYPE4 == */
	0x00000003, /* [0x0111] A5X_PC_POWER_CNTL_CTX_0 (0xE3B0)*/
	0x48E4F001, /* [0x0112] == TYPE4 == */
	0x00000003, /* [0x0113] A5X_VFD_POWER_CNTL_CTX_0 (0xE4F0)*/
	0x70268000, /* [0x0114] == TYPE7: WAIT_FOR_IDLE (26) == */
	0x400CC701, /* [0x0115] == TYPE4 == */
	0x7C13C080, /* [0x0116] A5X_RB_CCU_CNTL (0x0CC7)*/
	0x70EC8005, /* [0x0117] == TYPE7: SET_RENDER_MODE (6C) == */
	0x00000001, /* [0x0118] */
	0x00000000, /* [0x0119] */
	0x00000000, /* [0x011A] */
	0x00000010, /* [0x011B] */
	0x00000001, /* [0x011C] */
	0x70EA0001, /* [0x011D] == TYPE7: PREEMPT_ENABLE_LOCAL (6A) == */
	0x00000000, /* [0x011E] */
	0x48E0EA02, /* [0x011F] == TYPE4 == */
	0x00000000, /* [0x0120] A5X_GRAS_SC_WINDOW_SCISSOR_TL_CTX_0 (0xE0EA)*/
	0x001F0073, /* [0x0121] A5X_GRAS_SC_WINDOW_SCISSOR_BR_CTX_0 (0xE0EB)*/
	0x48E21102, /* [0x0122] == TYPE4 == */
	0x00000000, /* [0x0123] A5X_RB_RESOLVE_CNTL_1_CTX_0 (0xE211)*/
	0x00030007, /* [0x0124] A5X_RB_RESOLVE_CNTL_2_CTX_0 (0xE212)*/
	0x70138000, /* [0x0125] == TYPE7: WAIT_FOR_ME (13) == */
	0x70640001, /* [0x0126] == TYPE7: SET_VISIBILITY_OVERRIDE (64) == */
	0x00000000, /* [0x0127] */
	0x702F8005, /* [0x0128] == TYPE7: SET_BIN_DATA (2F) == */
	0x00010000, /* [0x0129] */
	0x00000000, /* [0x012A] */
	0x00000000, /* [0x012B] */
	0x00000000, /* [0x012C] */
	0x00000000, /* [0x012D] */
	0x40E1D001, /* [0x012E] == TYPE4 == */
	0x00000000, /* [0x012F] A5X_RB_WINDOW_OFFSET_CTX_0 (0xE1D0)*/
	0x40E2A201, /* [0x0130] == TYPE4 == */
	0x00000001, /* [0x0131] A5X_VPC_SO_OVERRIDE_CTX_0 (0xE2A2)*/
	0x70640001, /* [0x0132] == TYPE7: SET_VISIBILITY_OVERRIDE (64) == */
	0x00000000, /* [0x0133] */
	0x48E1B285, /* [0x0134] == TYPE4 == */
	0x00000001, /* [0x0135] A5X_RB_DEPTH_BUFFER_INFO_CTX_0 (0xE1B2)*/
	0x00004000, /* [0x0136] A5X_RB_DEPTH_BUFFER_BASE_LO_CTX_0 (0xE1B3)*/
	0x00000000, /* [0x0137] A5X_RB_DEPTH_BUFFER_BASE_HI_CTX_0 (0xE1B4)*/
	0x00000004, /* [0x0138] A5X_RB_DEPTH_BUFFER_PITCH_CTX_0 (0xE1B5)*/
	0x000000C0, /* [0x0139] A5X_RB_DEPTH_BUFFER_ARRAY_PITCH_CTX_0 (0xE1B6)*/
	0x48E09801, /* [0x013A] == TYPE4 == */
	0x00000001, /* [0x013B] A5X_GRAS_SU_DEPTH_BUFFER_INFO_CTX_0 (0xE098)*/
	0x40E24083, /* [0x013C] == TYPE4 == */
	0x00000000, /* [0x013D] A5X_RB_DEPTH_FLAG_BUFFER_BASE_LO_CTX_0
		     * (0xE240)
		     */
	0x00000000, /* [0x013E] A5X_RB_DEPTH_FLAG_BUFFER_BASE_HI_CTX_0
		     * (0xE241)
		     */
	0x00000000, /* [0x013F] A5X_RB_DEPTH_FLAG_BUFFER_PITCH_CTX_0 (0xE242)*/
	0x40E15285, /* [0x0140] == TYPE4 == */
	0x00001230, /* [0x0141] A5X_RB_MRT_BUFFER_INFO_0_CTX_0 (0xE152)*/
	0x00000008, /* [0x0142] A5X_RB_MRT_BUFFER_PITCH_0_CTX_0 (0xE153)*/
	0x00000100, /* [0x0143] A5X_RB_MRT_BUFFER_ARRAY_PITCH_0_CTX_0 (0xE154)*/
	0x00000000, /* [0x0144] A5X_RB_MRT_BUFFER_BASE_LO_0_CTX_0 (0xE155)*/
	0x00000000, /* [0x0145] A5X_RB_MRT_BUFFER_BASE_HI_0_CTX_0 (0xE156)*/
	0x40E40801, /* [0x0146] == TYPE4 == */
	0x00000000, /* [0x0147] A5X_VFD_INDEX_OFFSET_CTX_0 (0xE408)*/
	0x48E40901, /* [0x0148] == TYPE4 == */
	0x00000000, /* [0x0149] A5X_VFD_INSTANCE_START_OFFSET_CTX_0 (0xE409)*/
	0x70BF8003, /* [0x014A] == TYPE7: INDIRECT_BUFFER_PFE (3F) == */
	0x00000000, /* [0x014B] */
	0x00000000, /* [0x014C] */
	0x00000112, /* [0x014D] */
	0x70230001, /* [0x014E] == TYPE7: SKIP_IB2_ENABLE_LOCAL (23) == */
	0x00000000, /* [0x014F] */
	0x70BF8003, /* [0x0150] == TYPE7: INDIRECT_BUFFER_PFE (3F) == */
	0x00000000, /* [0x0151] */
	0x00000000, /* [0x0152] */
	0x0000001B, /* [0x0153] */
	0x70EC8005, /* [0x0154] == TYPE7: SET_RENDER_MODE (6C) == */
	0x00000001, /* [0x0155] */
	0x00000000, /* [0x0156] */
	0x00000000, /* [0x0157] */
	0x00000000, /* [0x0158] */
	0x00000001, /* [0x0159] */
	0x70438003, /* [0x015A] == TYPE7: SET_DRAW_STATE (43) == */
	0x00080059, /* [0x015B] */
	0x00000000, /* [0x015C] */
	0x00000000, /* [0x015D] */
	0x70388003, /* [0x015E] == TYPE7: DRAW_INDX_OFFSET (38) == */
	0x00000888, /* [0x015F] */
	0x00000000, /* [0x0160] */
	0x00000002, /* [0x0161] */
	0x70A88003, /* [0x0162] == TYPE7: DRAW_INDIRECT (28) == */
	0x00200884, /* [0x0163] */
	0x00000000, /* [0x0164] */
	0x00000000, /* [0x0165] */
	0x70298006, /* [0x0166] == TYPE7: DRAW_INDX_INDIRECT (29) == */
	0x00200404, /* [0x0167] */
	0x00000000, /* [0x0168] */
	0x00000000, /* [0x0169] */
	0x00000006, /* [0x016A] */
	0x00000000, /* [0x016B] */
	0x00000000, /* [0x016C] */
	0x40E2A783, /* [0x016D] == TYPE4 == */
	0x00000000, /* [0x016E] A5X_VPC_SO_BUFFER_BASE_LO_0_CTX_0 (0xE2A7)*/
	0x00000000, /* [0x016F] A5X_VPC_SO_BUFFER_BASE_HI_0_CTX_0 (0xE2A8)*/
	0x00000004, /* [0x0170] A5X_VPC_SO_BUFFER_SIZE_0_CTX_0 (0xE2A9)*/
	0x48E2AC02, /* [0x0171] == TYPE4 == */
	0x00000000, /* [0x0172] A5X_VPC_SO_FLUSH_BASE_LO_0_CTX_0 (0xE2AC)*/
	0x00000000, /* [0x0173] A5X_VPC_SO_FLUSH_BASE_HI_0_CTX_0 (0xE2AD)*/
	0x70460001, /* [0x0174] == TYPE7: EVENT_WRITE (46) == */
	0x00000011, /* [0x0175] */
	0x48E10001, /* [0x0176] == TYPE4 == */
	0x00000009, /* [0x0177] A5X_GRAS_LRZ_CNTL_CTX_0 (0xE100)*/
	0x70460001, /* [0x0178] == TYPE7: EVENT_WRITE (46) == */
	0x00000026, /* [0x0179] */
	0x48E10001, /* [0x017A] == TYPE4 == */
	0x00000008, /* [0x017B] A5X_GRAS_LRZ_CNTL_CTX_0 (0xE100)*/
	0x40E10185, /* [0x017C] == TYPE4 == */
	0x00000000, /* [0x017D] A5X_GRAS_LRZ_BUFFER_BASE_LO_CTX_0 (0xE101)*/
	0x00000000, /* [0x017E] A5X_GRAS_LRZ_BUFFER_BASE_HI_CTX_0 (0xE102)*/
	0x00000001, /* [0x017F] A5X_GRAS_LRZ_BUFFER_PITCH_CTX_0 (0xE103)*/
	0x00000000, /* [0x0180] A5X_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE_LO_CTX_0
		     * (0xE104)
		     */
	0x00000000, /* [0x0181] A5X_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE_HI_CTX_0
		     * (0xE105)
		     */
	0x70460001, /* [0x0182] == TYPE7: EVENT_WRITE (46) == */
	0x00000025, /* [0x0183] */
	0x70460001, /* [0x0184] == TYPE7: EVENT_WRITE (46) == */
	0x00000019, /* [0x0185] */
	0x70460001, /* [0x0186] == TYPE7: EVENT_WRITE (46) == */
	0x00000018, /* [0x0187] */
	0x70EA0001, /* [0x0188] == TYPE7: PREEMPT_ENABLE_LOCAL (6A) == */
	0x00000000, /* [0x0189] */
	0x70EC0001, /* [0x018A] == TYPE7: SET_RENDER_MODE (6C) == */
	0x00000006, /* [0x018B] */
	0x70438003, /* [0x018C] == TYPE7: SET_DRAW_STATE (43) == */
	0x00080059, /* [0x018D] */
	0x00000000, /* [0x018E] */
	0x00000000, /* [0x018F] */
	0x70DC0002, /* [0x0190] == TYPE7: CONTEXT_REG_BUNCH (5C) == */
	0x0000E2A1, /* [0x0191] */
	0x00008001, /* [0x0192] */
	0x709D0001, /* [0x0193] == TYPE7: SKIP_IB2_ENABLE_GLOBAL (1D) == */
	0x00000000, /* [0x0194] */
	0x70138000, /* [0x0195] == TYPE7: WAIT_FOR_ME (13) == */
	0x70640001, /* [0x0196] == TYPE7: SET_VISIBILITY_OVERRIDE (64) == */
	0x00000001, /* [0x0197] */
	0x70380007, /* [0x0198] == TYPE7: DRAW_INDX_OFFSET (38) == */
	0x00200506, /* [0x0199] */
	0x00000000, /* [0x019A] */
	0x00000004, /* [0x019B] */
	0x00000000, /* [0x019C] */
	0x00000000, /* [0x019D] */
	0x00000000, /* [0x019E] */
	0x00000004, /* [0x019F] */
	0x703D8005, /* [0x01A0] == TYPE7: MEM_WRITE (3D) == */
	0x00000000, /* [0x01A1] */
	0x00000000, /* [0x01A2] */
	0x00000001, /* [0x01A3] */
	0x00000001, /* [0x01A4] */
	0x00000001, /* [0x01A5] */
	0x70928000, /* [0x01A6] == TYPE7: WAIT_MEM_WRITES (12) == */
	0x70BF8003, /* [0x01A7] == TYPE7: INDIRECT_BUFFER_PFE (3F) == */
	0x00000000, /* [0x01A8] */
	0x00000000, /* [0x01A9] */
	0x00000028, /* [0x01AA] */
	0x70C48006, /* [0x01AB] == TYPE7: COND_EXEC (44) == */
	0x00000000, /* [0x01AC] */
	0x00000000, /* [0x01AD] */
	0x00000000, /* [0x01AE] */
	0x00000000, /* [0x01AF] */
	0x00000001, /* [0x01B0] */
	0x00000002, /* [0x01B1] */
	0x70100001, /* [0x01B2] == TYPE7: NOP (10) == */
	0x00000000, /* [0x01B3] */
	0x70C28003, /* [0x01B4] == TYPE7: MEM_TO_REG (42) == */
	0xC000E2AB, /* [0x01B5] */
	0x00000000, /* [0x01B6] */
	0x00000000, /* [0x01B7] */
	0x70230001, /* [0x01B8] == TYPE7: SKIP_IB2_ENABLE_LOCAL (23) == */
	0x00000000, /* [0x01B9] */
	0x70E90001, /* [0x01BA] == TYPE7: PREEMPT_ENABLE_GLOBAL (69) == */
	0x00000000, /* [0x01BB] */
	0x70BC8006, /* [0x01BC] == TYPE7: WAIT_REG_MEM (3C) == */
	0x00000010, /* [0x01BD] */
	0x00000000, /* [0x01BE] */
	0x00000000, /* [0x01BF] */
	0x00000001, /* [0x01C0] */
	0xFFFFFFFF, /* [0x01C1] */
	0x00000001, /* [0x01C2] */
	0x70738009, /* [0x01C3] == TYPE7: MEM_TO_MEM (73) == */
	0x20000004, /* [0x01C4] */
	0x00000000, /* [0x01C5] */
	0x00000000, /* [0x01C6] */
	0x00000000, /* [0x01C7] */
	0x00000000, /* [0x01C8] */
	0x00000000, /* [0x01C9] */
	0x00000000, /* [0x01CA] */
	0x00000000, /* [0x01CB] */
	0x00000000, /* [0x01CC] */
	0x70738009, /* [0x01CD] == TYPE7: MEM_TO_MEM (73) == */
	0xE0000004, /* [0x01CE] */
	0x00000000, /* [0x01CF] */
	0x00000000, /* [0x01D0] */
	0x00000000, /* [0x01D1] */
	0x00000000, /* [0x01D2] */
	0x00000000, /* [0x01D3] */
	0x00000000, /* [0x01D4] */
	0x00000000, /* [0x01D5] */
	0x00000000, /* [0x01D6] */
	0x70B50001, /* [0x01D7] == TYPE7: SET_SUBDRAW_SIZE (35) == */
	0x00000001, /* [0x01D8] */
	0x40E78A01, /* [0x01D9] == TYPE4 == */
	0x000FFFFF, /* [0x01DA] A5X_HLSQ_UPDATE_CNTL_CTX_0 (0xE78A)*/
	0x70268000, /* [0x01DB] == TYPE7: WAIT_FOR_IDLE (26) == */
	0x400E0601, /* [0x01DC] == TYPE4 == */
	0x00000001, /* [0x01DD] A5X_HLSQ_MODE_CNTL (0x0E06)*/
	0x706E0004, /* [0x01DE] == TYPE7: COMPUTE_CHECKPOINT (6E) == */
	0x00000000, /* [0x01DF] */
	0x00000000, /* [0x01E0] */
	0x00000018, /* [0x01E1] */
	0x00000001, /* [0x01E2] */
	0x40E14001, /* [0x01E3] == TYPE4 == */
	0x00020000, /* [0x01E4] A5X_RB_CNTL_CTX_0 (0xE140)*/
	0x40E78A01, /* [0x01E5] == TYPE4 == */
	0x01F00000, /* [0x01E6] A5X_HLSQ_UPDATE_CNTL_CTX_0 (0xE78A)*/
	0x70268000, /* [0x01E7] == TYPE7: WAIT_FOR_IDLE (26) == */
	0x48E38C01, /* [0x01E8] == TYPE4 == */
	0xFFFFFFFF, /* [0x01E9] A5X_PC_RESTART_INDEX_CTX_0 (0xE38C)*/
	0x480D0201, /* [0x01EA] == TYPE4 == */
	0x0000001F, /* [0x01EB] A5X_PC_MODE_CNTL (0x0D02)*/
	0x480EC201, /* [0x01EC] == TYPE4 == */
	0x0000001E, /* [0x01ED] A5X_SP_MODE_CNTL (0x0EC2)*/
	0x48E58001, /* [0x01EE] == TYPE4 == */
	0x00000000, /* [0x01EF] A5X_SP_SP_CNTL_CTX_0 (0xE580)*/
	0x40E2A201, /* [0x01F0] == TYPE4 == */
	0x00000001, /* [0x01F1] A5X_VPC_SO_OVERRIDE_CTX_0 (0xE2A2)*/
	0x70640001, /* [0x01F2] == TYPE7: SET_VISIBILITY_OVERRIDE (64) == */
	0x00000001, /* [0x01F3] */
	0x48E78401, /* [0x01F4] == TYPE4 == */
	0x00000881, /* [0x01F5] A5X_HLSQ_CNTL_0_CTX_0 (0xE784)*/
	0x40E5F001, /* [0x01F6] == TYPE4 == */
	0x00000C06, /* [0x01F7] A5X_SP_CS_CNTL_0_CTX_0 (0xE5F0)*/
	0x48E79001, /* [0x01F8] == TYPE4 == */
	0x00000001, /* [0x01F9] A5X_HLSQ_CS_CONFIG_CTX_0 (0xE790)*/
	0x48E79601, /* [0x01FA] == TYPE4 == */
	0x00000005, /* [0x01FB] A5X_HLSQ_CS_CNTL_CTX_0 (0xE796)*/
	0x48E58901, /* [0x01FC] == TYPE4 == */
	0x00000001, /* [0x01FD] A5X_SP_CS_CONFIG_CTX_0 (0xE589)*/
	0x40E7DC01, /* [0x01FE] == TYPE4 == */
	0x00000030, /* [0x01FF] A5X_HLSQ_CONTEXT_SWITCH_CS_SW_3_CTX_0 (0xE7DC)*/
	0x48E7DD01, /* [0x0200] == TYPE4 == */
	0x00000002, /* [0x0201] A5X_HLSQ_CONTEXT_SWITCH_CS_SW_4_CTX_0 (0xE7DD)*/
	0x40E7B001, /* [0x0202] == TYPE4 == */
	0x00000003, /* [0x0203] A5X_HLSQ_CS_NDRANGE_0_CTX_0 (0xE7B0)*/
	0x48E7B702, /* [0x0204] == TYPE4 == */
	0x00FCC0CF, /* [0x0205] A5X_HLSQ_CS_CNTL_0_CTX_0 (0xE7B7)*/
	0x00000000, /* [0x0206] A5X_HLSQ_CS_CNTL_1_CTX_0 (0xE7B8)*/
	0x40E7B983, /* [0x0207] == TYPE4 == */
	0x00000001, /* [0x0208] A5X_HLSQ_CS_KERNEL_GROUP_X_CTX_0 (0xE7B9)*/
	0x00000001, /* [0x0209] A5X_HLSQ_CS_KERNEL_GROUP_Y_CTX_0 (0xE7BA)*/
	0x00000001, /* [0x020A] A5X_HLSQ_CS_KERNEL_GROUP_Z_CTX_0 (0xE7BB)*/
	0x70B08003, /* [0x020B] == TYPE7: LOAD_STATE (30) == */
	0x00B60000, /* [0x020C] */
	0x00000000, /* [0x020D] */
	0x00000000, /* [0x020E] */
	0x70B08003, /* [0x020F] == TYPE7: LOAD_STATE (30) == */
	0x01360008, /* [0x0210] */
	0x00000000, /* [0x0211] */
	0x00000000, /* [0x0212] */
	0x70B0000B, /* [0x0213] == TYPE7: LOAD_STATE (30) == */
	0x00BC0000, /* [0x0214] */
	0x00000000, /* [0x0215] */
	0x00000000, /* [0x0216] */
	0x00000000, /* [0x0217] */
	0x00000000, /* [0x0218] */
	0x00000000, /* [0x0219] */
	0x00000000, /* [0x021A] */
	0x00000000, /* [0x021B] */
	0x00000000, /* [0x021C] */
	0x00000000, /* [0x021D] */
	0x00000000, /* [0x021E] */
	0x70B00007, /* [0x021F] == TYPE7: LOAD_STATE (30) == */
	0x00BC0000, /* [0x0220] */
	0x00000001, /* [0x0221] */
	0x00000000, /* [0x0222] */
	0x00040000, /* [0x0223] */
	0x00000000, /* [0x0224] */
	0x00040000, /* [0x0225] */
	0x00000000, /* [0x0226] */
	0x70B00007, /* [0x0227] == TYPE7: LOAD_STATE (30) == */
	0x00BC0000, /* [0x0228] */
	0x00000002, /* [0x0229] */
	0x00000000, /* [0x022A] */
	0x00000000, /* [0x022B] */
	0x00000000, /* [0x022C] */
	0x00000000, /* [0x022D] */
	0x00000000, /* [0x022E] */
	0x48E7B186, /* [0x022F] == TYPE4 == */
	0x00000001, /* [0x0230] A5X_HLSQ_CS_NDRANGE_1_CTX_0 (0xE7B1)*/
	0x00000000, /* [0x0231] A5X_HLSQ_CS_NDRANGE_2_CTX_0 (0xE7B2)*/
	0x00000001, /* [0x0232] A5X_HLSQ_CS_NDRANGE_3_CTX_0 (0xE7B3)*/
	0x00000000, /* [0x0233] A5X_HLSQ_CS_NDRANGE_4_CTX_0 (0xE7B4)*/
	0x00000001, /* [0x0234] A5X_HLSQ_CS_NDRANGE_5_CTX_0 (0xE7B5)*/
	0x00000000, /* [0x0235] A5X_HLSQ_CS_NDRANGE_6_CTX_0 (0xE7B6)*/
	0x70B30004, /* [0x0236] == TYPE7: EXEC_CS (33) == */
	0x00000000, /* [0x0237] */
	0x00000001, /* [0x0238] */
	0x00000001, /* [0x0239] */
	0x00000001, /* [0x023A] */
	0x480E6201, /* [0x023B] == TYPE4 == */
	0x00000001, /* [0x023C] A5X_VPC_MODE_CNTL (0x0E62)*/
};

/*
 * These are fixups for the addresses _a5xx_critical_pkts[]. The first two
 * numbers are the dword offsets into the buffer above.  The third enum is a
 * clue as to which buffer is being patched in and the final number is an offset
 * in said buffer.
 */
static const struct adreno_critical_fixup critical_pkt_fixups[] = {
	{ 132, 133, 2, 0x0000 },
	{ 136, 137, 2, 0x0001 },
	{ 154, 155, 2, 0x0100 },
	{ 159, 160, 2, 0x0104 },
	{ 173, 174, 2, 0x0200 },
	{ 177, 178, 2, 0x0300 },
	{ 236, 237, 0, 0x0000 },
	{ 244, 245, 0, 0x0040 },
	{ 259, 260, 3, 0x0000 },
	{ 266, 267, 2, 0x0108 },
	{ 298, 299, 0, 0x0040 },
	{ 300, 301, 2, 0x0080 },
	{ 331, 332, 3, 0x02A0 },
	{ 337, 338, 3, 0x0700 },
	{ 348, 349, 3, 0x0920 },
	{ 356, 357, 1, 0x008C },
	{ 360, 361, 1, 0x0080 },
	{ 363, 364, 1, 0x008C },
	{ 366, 367, 0, 0x0100 },
	{ 370, 371, 0, 0x0120 },
	{ 381, 382, 1, 0x0480 },
	{ 384, 385, 1, 0x0400 },
	{ 398, 399, 3, 0x0920 },
	{ 413, 414, 1, 0x0080 },
	{ 417, 418, 1, 0x0300 },
	{ 424, 425, 3, 0x0880 },
	{ 428, 429, 1, 0x0300 },
	{ 430, 431, 1, 0x0300 },
	{ 438, 439, 1, 0x0300 },
	{ 446, 447, 1, 0x0300 },
	{ 453, 454, 1, 0x0320 },
	{ 455, 456, 1, 0x0300 },
	{ 457, 458, 1, 0x0304 },
	{ 459, 460, 1, 0x0308 },
	{ 463, 464, 1, 0x0320 },
	{ 465, 466, 1, 0x0300 },
	{ 467, 468, 1, 0x0304 },
	{ 469, 470, 1, 0x0308 },
	{ 525, 526, 1, 0x0160 },
	{ 529, 530, 1, 0x0101 },
	{ 535, 536, 1, 0x0140 },
	{ 539, 540, 0, 0x0800 },
	{ 555, 556, 1, 0x0140 },
	{ 557, 558, 0, 0x0800 },
};

static unsigned int _a5xx_critical_pkts_mem01[] = {
	0xBECCCCCD, 0x00000000, 0x3ECCCCCD, 0x00000000, 0x3ECCCCCD, 0x3ECCCCCD,
	0xBECCCCCD, 0x00000000, 0xBECCCCCD, 0x3ECCCCCD, 0x3ECCCCCD, 0x00000000,
	0xBECCCCCD, 0x00000000, 0x3ECCCCCD, 0x00000000, 0x3ECCCCCD, 0xBECCCCCD,
	0xBECCCCCD, 0x00000000, 0xBECCCCCD, 0xBECCCCCD, 0x3ECCCCCD, 0x00000000,
	0x3ECCCCCD, 0x00000000, 0x3ECCCCCD, 0x00000000, 0x3ECCCCCD, 0x00000000,
	0x00000000, 0x00000000, 0x00040003, 0x00090005, 0x000B000A, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000003, 0x00000001,
	0x00000006, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000003, 0x00000001, 0x00000003, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x3EF5C28F, 0x3ED1EB85, 0x3E6147AE, 0x3F800000,
	0x3E947AE1, 0x3E6147AE, 0x3D4CCCCD, 0x3F800000, 0x00000000, 0x20554002,
	0x3F800000, 0x20444003, 0x000000CF, 0x20044904, 0x00000000, 0x00000200,
	0x00050001, 0x42300001, 0x00000002, 0x20154005, 0x00000020, 0x20244006,
	0x00000000, 0x00000000, 0x10200001, 0x46500007, 0x20030004, 0x46D00004,
	0x00000000, 0x20554008, 0x00070001, 0x61830806, 0x00061020, 0x61808001,
	0x00040000, 0x42380800, 0x00010000, 0x42380800, 0x20040000, 0x46D80800,
	0x00000000, 0x20154007, 0x20020000, 0x46F80000, 0x00000007, 0x20154001,
	0x00000000, 0x00000200, 0x60030001, 0x43900004, 0x60030001, 0x43900001,
	0x00000000, 0x00000400, 0x00013600, 0xC6E20004, 0x40040003, 0x50180104,
	0x40060003, 0x40180803, 0x00000003, 0x20044006, 0x00000000, 0x00000500,
	0x00003609, 0xC7260201, 0x00000000, 0x03000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000,
};

static unsigned int _a5xx_critical_pkts_mem02[] = {
	0x00000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x0000000C, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8ACFE7F3, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
};

static unsigned int _a5xx_critical_pkts_mem03[] = {
	0x70438003, /* [0x0000] == TYPE7: SET_DRAW_STATE (43) == */
	0x0008003A, /* [0x0001] */
	0x00000000, /* [0x0002] */
	0x00000000, /* [0x0003] */
	0x70B08003, /* [0x0004] == TYPE7: LOAD_STATE (30) == */
	0x00620000, /* [0x0005] */
	0x00000000, /* [0x0006] */
	0x00000000, /* [0x0007] */
	0x40E29801, /* [0x0008] == TYPE4 == */
	0x0000FFFF, /* [0x0009] A5X_VPC_GS_SIV_CNTL_CTX_0 (0xE298)*/
	0x48E2A001, /* [0x000A] == TYPE4 == */
	0x000000FF, /* [0x000B] A5X_VPC_PS_PRIMITIVEID_CNTL_CTX_0 (0xE2A0)*/
	0x40E40185, /* [0x000C] == TYPE4 == */
	0x00FCFCFC, /* [0x000D] A5X_VFD_CNTL_1_CTX_0 (0xE401)*/
	0x0000FCFC, /* [0x000E] A5X_VFD_CNTL_2_CTX_0 (0xE402)*/
	0x0000FCFC, /* [0x000F] A5X_VFD_CNTL_3_CTX_0 (0xE403)*/
	0x000000FC, /* [0x0010] A5X_VFD_CNTL_4_CTX_0 (0xE404)*/
	0x00000000, /* [0x0011] A5X_VFD_CNTL_5_CTX_0 (0xE405)*/
	0x48E38F01, /* [0x0012] == TYPE4 == */
	0x00000000, /* [0x0013] A5X_PC_HS_PARAM_CTX_0 (0xE38F)*/
	0x48E58001, /* [0x0014] == TYPE4 == */
	0x00000010, /* [0x0015] A5X_SP_SP_CNTL_CTX_0 (0xE580)*/
	0x40E00001, /* [0x0016] == TYPE4 == */
	0x00000080, /* [0x0017] A5X_GRAS_CL_CNTL_CTX_0 (0xE000)*/
	0x40E09583, /* [0x0018] == TYPE4 == */
	0x00000000, /* [0x0019] A5X_GRAS_SU_POLY_OFFSET_SCALE_CTX_0 (0xE095)*/
	0x00000000, /* [0x001A] A5X_GRAS_SU_POLY_OFFSET_OFFSET_CTX_0 (0xE096)*/
	0x00000000, /* [0x001B] A5X_GRAS_SU_POLY_OFFSET_OFFSET_CLAMP_CTX_0
		     * (0xE097)
		     */
	0x40E09001, /* [0x001C] == TYPE4 == */
	0x00000010, /* [0x001D] A5X_GRAS_SU_CNTL_CTX_0 (0xE090)*/
	0x40E0AA02, /* [0x001E] == TYPE4 == */
	0x00000000, /* [0x001F] A5X_GRAS_SC_SCREEN_SCISSOR_TL_0_CTX_0 (0xE0AA)*/
	0x001F0073, /* [0x0020] A5X_GRAS_SC_SCREEN_SCISSOR_BR_0_CTX_0 (0xE0AB)*/
	0x48E01086, /* [0x0021] == TYPE4 == */
	0x42680000, /* [0x0022] A5X_GRAS_CL_VIEWPORT_XOFFSET_0_CTX_0 (0xE010)*/
	0x42680000, /* [0x0023] A5X_GRAS_CL_VIEWPORT_XSCALE_0_CTX_0 (0xE011)*/
	0x41800000, /* [0x0024] A5X_GRAS_CL_VIEWPORT_YOFFSET_0_CTX_0 (0xE012)*/
	0xC1800000, /* [0x0025] A5X_GRAS_CL_VIEWPORT_YSCALE_0_CTX_0 (0xE013)*/
	0x3EFFFEE0, /* [0x0026] A5X_GRAS_CL_VIEWPORT_ZOFFSET_0_CTX_0 (0xE014)*/
	0x3EFFFEE0, /* [0x0027] A5X_GRAS_CL_VIEWPORT_ZSCALE_0_CTX_0 (0xE015)*/
	0x40E0CA02, /* [0x0028] == TYPE4 == */
	0x00000000, /* [0x0029] A5X_GRAS_SC_VIEWPORT_SCISSOR_TL_0_CTX_0
		     * (0xE0CA)
		     */
	0x001F0073, /* [0x002A] A5X_GRAS_SC_VIEWPORT_SCISSOR_BR_0_CTX_0
		     * (0xE0CB)
		     */
	0x40E00601, /* [0x002B] == TYPE4 == */
	0x0007FDFF, /* [0x002C] A5X_GRAS_CL_GUARDBAND_CLIP_ADJ_CTX_0 (0xE006)*/
	0x40E70401, /* [0x002D] == TYPE4 == */
	0x00000000, /* [0x002E] A5X_TPL1_TP_RAS_MSAA_CNTL_CTX_0 (0xE704)*/
	0x48E70501, /* [0x002F] == TYPE4 == */
	0x00000004, /* [0x0030] A5X_TPL1_TP_DEST_MSAA_CNTL_CTX_0 (0xE705)*/
	0x48E14201, /* [0x0031] == TYPE4 == */
	0x00000000, /* [0x0032] A5X_RB_RAS_MSAA_CNTL_CTX_0 (0xE142)*/
	0x40E14301, /* [0x0033] == TYPE4 == */
	0x00000004, /* [0x0034] A5X_RB_DEST_MSAA_CNTL_CTX_0 (0xE143)*/
	0x40E78683, /* [0x0035] == TYPE4 == */
	0xFCFCFCFC, /* [0x0036] A5X_HLSQ_CNTL_2_CTX_0 (0xE786)*/
	0xFCFCFCFC, /* [0x0037] A5X_HLSQ_CNTL_3_CTX_0 (0xE787)*/
	0xFCFCFCFC, /* [0x0038] A5X_HLSQ_CNTL_4_CTX_0 (0xE788)*/
	0x48E0A201, /* [0x0039] == TYPE4 == */
	0x00000000, /* [0x003A] A5X_GRAS_SC_RAS_MSAA_CNTL_CTX_0 (0xE0A2)*/
	0x40E0A301, /* [0x003B] == TYPE4 == */
	0x00000004, /* [0x003C] A5X_GRAS_SC_DEST_MSAA_CNTL_CTX_0 (0xE0A3)*/
	0x48E14101, /* [0x003D] == TYPE4 == */
	0x0000C089, /* [0x003E] A5X_RB_RENDER_CNTL_CTX_0 (0xE141)*/
	0x40E0A001, /* [0x003F] == TYPE4 == */
	0x00000009, /* [0x0040] A5X_GRAS_SC_CNTL_CTX_0 (0xE0A0)*/
	0x40E28001, /* [0x0041] == TYPE4 == */
	0x00010004, /* [0x0042] A5X_VPC_CNTL_0_CTX_0 (0xE280)*/
	0x40E38401, /* [0x0043] == TYPE4 == */
	0x00000404, /* [0x0044] A5X_PC_PRIMITIVE_CNTL_CTX_0 (0xE384)*/
	0x40E78501, /* [0x0045] == TYPE4 == */
	0x0000003F, /* [0x0046] A5X_HLSQ_CNTL_1_CTX_0 (0xE785)*/
	0x48E5D301, /* [0x0047] == TYPE4 == */
	0x00000030, /* [0x0048] A5X_SP_PS_MRT_0_CTX_0 (0xE5D3)*/
	0x48E5CB01, /* [0x0049] == TYPE4 == */
	0x00000100, /* [0x004A] A5X_SP_PS_OUTPUT_0_CTX_0 (0xE5CB)*/
	0x40E5CA01, /* [0x004B] == TYPE4 == */
	0x001F9F81, /* [0x004C] A5X_SP_PS_OUTPUT_CNTL_CTX_0 (0xE5CA)*/
	0x40E14601, /* [0x004D] == TYPE4 == */
	0x00000001, /* [0x004E] A5X_RB_PS_OUTPUT_CNTL_CTX_0 (0xE146)*/
	0x40E38E01, /* [0x004F] == TYPE4 == */
	0x00000000, /* [0x0050] A5X_PC_GS_PARAM_CTX_0 (0xE38E)*/
	0x40E28A01, /* [0x0051] == TYPE4 == */
	0x00000000, /* [0x0052] A5X_VPC_VARYING_REPLACE_MODE_0_CTX_0 (0xE28A)*/
	0x48E1A901, /* [0x0053] == TYPE4 == */
	0xFFFF0100, /* [0x0054] A5X_RB_BLEND_CNTL_CTX_0 (0xE1A9)*/
	0x40E5C901, /* [0x0055] == TYPE4 == */
	0x00000100, /* [0x0056] A5X_SP_BLEND_CNTL_CTX_0 (0xE5C9)*/
	0x40E76401, /* [0x0057] == TYPE4 == */
	0x00000000, /* [0x0058] A5X_TPL1_TP_PS_ROTATION_CNTL_CTX_0 (0xE764)*/
	0x48E09401, /* [0x0059] == TYPE4 == */
	0x00000000, /* [0x005A] A5X_GRAS_SU_DEPTH_PLANE_CNTL_CTX_0 (0xE094)*/
	0x40E1B001, /* [0x005B] == TYPE4 == */
	0x00000000, /* [0x005C] A5X_RB_DEPTH_PLANE_CNTL_CTX_0 (0xE1B0)*/
	0x48E1B101, /* [0x005D] == TYPE4 == */
	0x00000000, /* [0x005E] A5X_RB_DEPTH_CNTL_CTX_0 (0xE1B1)*/
	0x48E40001, /* [0x005F] == TYPE4 == */
	0x00000001, /* [0x0060] A5X_VFD_CNTL_0_CTX_0 (0xE400)*/
	0x48E40A04, /* [0x0061] == TYPE4 == */
	0x00000000, /* [0x0062] A5X_VFD_VERTEX_BUFFER_BASE_LO_0_CTX_0 (0xE40A)*/
	0x00000000, /* [0x0063] A5X_VFD_VERTEX_BUFFER_BASE_HI_0_CTX_0 (0xE40B)*/
	0x00000078, /* [0x0064] A5X_VFD_VERTEX_BUFFER_SIZE_0_CTX_0 (0xE40C)*/
	0x00000008, /* [0x0065] A5X_VFD_VERTEX_BUFFER_STRIDE_0_CTX_0 (0xE40D)*/
	0x40E48A02, /* [0x0066] == TYPE4 == */
	0xC6700000, /* [0x0067] A5X_VFD_FETCH_INSTR_0_CTX_0 (0xE48A)*/
	0x00000001, /* [0x0068] A5X_VFD_FETCH_INSTR_STEP_RATE_0_CTX_0 (0xE48B)*/
	0x48E4CA01, /* [0x0069] == TYPE4 == */
	0x0000000F, /* [0x006A] A5X_VFD_DEST_CNTL_0_CTX_0 (0xE4CA)*/
	0x48E10001, /* [0x006B] == TYPE4 == */
	0x00000008, /* [0x006C] A5X_GRAS_LRZ_CNTL_CTX_0 (0xE100)*/
	0x48E0A101, /* [0x006D] == TYPE4 == */
	0x00000004, /* [0x006E] A5X_GRAS_SC_BIN_CNTL_CTX_0 (0xE0A1)*/
	0x40E10185, /* [0x006F] == TYPE4 == */
	0x00000000, /* [0x0070] A5X_GRAS_LRZ_BUFFER_BASE_LO_CTX_0 (0xE101)*/
	0x00000000, /* [0x0071] A5X_GRAS_LRZ_BUFFER_BASE_HI_CTX_0 (0xE102)*/
	0x00000001, /* [0x0072] A5X_GRAS_LRZ_BUFFER_PITCH_CTX_0 (0xE103)*/
	0x00000000, /* [0x0073] A5X_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE_LO_CTX_0
		     * (0xE104)
		     */
	0x00000000, /* [0x0074] A5X_GRAS_LRZ_FAST_CLEAR_BUFFER_BASE_HI_CTX_0
		     * (0xE105)
		     */
	0x70388003, /* [0x0075] == TYPE7: DRAW_INDX_OFFSET (38) == */
	0x00200884, /* [0x0076] */
	0x00000001, /* [0x0077] */
	0x00000003, /* [0x0078] */
	0x70380007, /* [0x0079] == TYPE7: DRAW_INDX_OFFSET (38) == */
	0x00200404, /* [0x007A] */
	0x00000001, /* [0x007B] */
	0x00000003, /* [0x007C] */
	0x00000000, /* [0x007D] */
	0x00000000, /* [0x007E] */
	0x00000000, /* [0x007F] */
	0x00000006, /* [0x0080] */
	0x70460004, /* [0x0081] == TYPE7: EVENT_WRITE (46) == */
	0x00000004, /* [0x0082] */
	0x00000000, /* [0x0083] */
	0x00000000, /* [0x0084] */
	0x00000001, /* [0x0085] */
	0x70268000, /* [0x0086] == TYPE7: WAIT_FOR_IDLE (26) == */
	0x70A88003, /* [0x0087] == TYPE7: DRAW_INDIRECT (28) == */
	0x00200884, /* [0x0088] */
	0x00000000, /* [0x0089] */
	0x00000000, /* [0x008A] */
	0x70460004, /* [0x008B] == TYPE7: EVENT_WRITE (46) == */
	0x00000004, /* [0x008C] */
	0x00000000, /* [0x008D] */
	0x00000000, /* [0x008E] */
	0x00000001, /* [0x008F] */
	0x70268000, /* [0x0090] == TYPE7: WAIT_FOR_IDLE (26) == */
	0x70298006, /* [0x0091] == TYPE7: DRAW_INDX_INDIRECT (29) == */
	0x00200404, /* [0x0092] */
	0x00000000, /* [0x0093] */
	0x00000000, /* [0x0094] */
	0x00000006, /* [0x0095] */
	0x00000000, /* [0x0096] */
	0x00000000, /* [0x0097] */
	0x40E40801, /* [0x0098] == TYPE4 == */
	0x0000000D, /* [0x0099] A5X_VFD_INDEX_OFFSET_CTX_0 (0xE408)*/
	0x48E40901, /* [0x009A] == TYPE4 == */
	0x00000000, /* [0x009B] A5X_VFD_INSTANCE_START_OFFSET_CTX_0 (0xE409)*/
	0x70388003, /* [0x009C] == TYPE7: DRAW_INDX_OFFSET (38) == */
	0x00200884, /* [0x009D] */
	0x00000001, /* [0x009E] */
	0x00000003, /* [0x009F] */
	0x00000000, /* [0x00A0] */
	0x00000000, /* [0x00A1] */
	0x00000000, /* [0x00A2] */
	0x00000000, /* [0x00A3] */
	0x00000000, /* [0x00A4] */
	0x00000000, /* [0x00A5] */
	0x00000000, /* [0x00A6] */
	0x00000000, /* [0x00A7] */
	0x48E78401, /* [0x00A8] */
	0x00000881, /* [0x00A9] */
	0x40E5C001, /* [0x00AA] */
	0x0004001E, /* [0x00AB] */
	0x70438003, /* [0x00AC] */
	0x0000003A, /* [0x00AD] */
	0x00000000, /* [0x00AE] */
	0x00000000, /* [0x00AF] */
	0x70B00023, /* [0x00B0] */
	0x00600000, /* [0x00B1] */
	0x00000000, /* [0x00B2] */
	0x00000000, /* [0x00B3] */
	0x00000000, /* [0x00B4] */
	0x03000000, /* [0x00B5] */
	0x00000000, /* [0x00B6] */
	0x00000000, /* [0x00B7] */
	0x00000000, /* [0x00B8] */
	0x00000000, /* [0x00B9] */
	0x00000000, /* [0x00BA] */
	0x00000000, /* [0x00BB] */
	0x00000000, /* [0x00BC] */
	0x00000000, /* [0x00BD] */
	0x00000000, /* [0x00BE] */
	0x00000000, /* [0x00BF] */
	0x00000000, /* [0x00C0] */
	0x00000000, /* [0x00C1] */
	0x00000000, /* [0x00C2] */
	0x00000000, /* [0x00C3] */
	0x00000000, /* [0x00C4] */
	0x00000000, /* [0x00C5] */
	0x00000000, /* [0x00C6] */
	0x00000000, /* [0x00C7] */
	0x00000000, /* [0x00C8] */
	0x00000000, /* [0x00C9] */
	0x00000000, /* [0x00CA] */
	0x00000000, /* [0x00CB] */
	0x00000000, /* [0x00CC] */
	0x00000000, /* [0x00CD] */
	0x00000000, /* [0x00CE] */
	0x00000000, /* [0x00CF] */
	0x00000000, /* [0x00D0] */
	0x00000000, /* [0x00D1] */
	0x00000000, /* [0x00D2] */
	0x00000000, /* [0x00D3] */
	0x40E09301, /* [0x00D4] */
	0x00000000, /* [0x00D5] */
	0x40E38D01, /* [0x00D6] */
	0x00000000, /* [0x00D7] */
	0x40E29801, /* [0x00D8] */
	0x0000FFFF, /* [0x00D9] */
	0x48E28201, /* [0x00DA] */
	0xEAEAEAEA, /* [0x00DB] */
	0x40E29404, /* [0x00DC] */
	0xFFFFFFFF, /* [0x00DD] */
	0xFFFFFFFF, /* [0x00DE] */
	0xFFFFFFFF, /* [0x00DF] */
	0xFFFFFFFF, /* [0x00E0] */
	0x40E5DB01, /* [0x00E1] */
	0x00000000, /* [0x00E2] */
	0x48E14701, /* [0x00E3] */
	0x0000000F, /* [0x00E4] */
	0x70B00023, /* [0x00E5] */
	0x00700000, /* [0x00E6] */
	0x00000000, /* [0x00E7] */
	0x00000000, /* [0x00E8] */
	0x00003C00, /* [0x00E9] */
	0x20400000, /* [0x00EA] */
	0x00000000, /* [0x00EB] */
	0x20400001, /* [0x00EC] */
	0x00000000, /* [0x00ED] */
	0x20400002, /* [0x00EE] */
	0x00003C00, /* [0x00EF] */
	0x20400003, /* [0x00F0] */
	0x00000000, /* [0x00F1] */
	0x03000000, /* [0x00F2] */
	0x00000000, /* [0x00F3] */
	0x00000000, /* [0x00F4] */
	0x00000000, /* [0x00F5] */
	0x00000000, /* [0x00F6] */
	0x00000000, /* [0x00F7] */
	0x00000000, /* [0x00F8] */
	0x00000000, /* [0x00F9] */
	0x00000000, /* [0x00FA] */
	0x00000000, /* [0x00FB] */
	0x00000000, /* [0x00FC] */
	0x00000000, /* [0x00FD] */
	0x00000000, /* [0x00FE] */
	0x00000000, /* [0x00FF] */
	0x00000000, /* [0x0100] */
	0x00000000, /* [0x0101] */
	0x00000000, /* [0x0102] */
	0x00000000, /* [0x0103] */
	0x00000000, /* [0x0104] */
	0x00000000, /* [0x0105] */
	0x00000000, /* [0x0106] */
	0x00000000, /* [0x0107] */
	0x00000000, /* [0x0108] */
	0x48E2A001, /* [0x0109] */
	0x000000FF, /* [0x010A] */
	0x40E40185, /* [0x010B] */
	0x00FCFCFC, /* [0x010C] */
	0x0000FCFC, /* [0x010D] */
	0x0000FCFC, /* [0x010E] */
	0x000000FC, /* [0x010F] */
	0x00000000, /* [0x0110] */
	0x48E38F01, /* [0x0111] */
	0x00000000, /* [0x0112] */
	0x48E58001, /* [0x0113] */
	0x00000010, /* [0x0114] */
	0x40E1A801, /* [0x0115] */
	0x00000E00, /* [0x0116] */
	0x48E15001, /* [0x0117] */
	0x000007E0, /* [0x0118] */
	0x40E15101, /* [0x0119] */
	0x00000000, /* [0x011A] */
	0x40E00001, /* [0x011B] */
	0x00000080, /* [0x011C] */
	0x40E09583, /* [0x011D] */
	0x00000000, /* [0x011E] */
	0x00000000, /* [0x011F] */
	0x00000000, /* [0x0120] */
	0x40E09001, /* [0x0121] */
	0x00000010, /* [0x0122] */
	0x40E0AA02, /* [0x0123] */
	0x00000000, /* [0x0124] */
	0x001F0073, /* [0x0125] */
	0x48E01086, /* [0x0126] */
	0x42680000, /* [0x0127] */
	0x42680000, /* [0x0128] */
	0x41800000, /* [0x0129] */
	0xC1800000, /* [0x012A] */
	0x3EFFFEE0, /* [0x012B] */
	0x3EFFFEE0, /* [0x012C] */
	0x40E0CA02, /* [0x012D] */
	0x00000000, /* [0x012E] */
	0x001F0073, /* [0x012F] */
	0x40E00601, /* [0x0130] */
	0x0007FDFF, /* [0x0131] */
	0x40E70401, /* [0x0132] */
	0x00000000, /* [0x0133] */
	0x48E70501, /* [0x0134] */
	0x00000004, /* [0x0135] */
	0x48E14201, /* [0x0136] */
	0x00000000, /* [0x0137] */
	0x40E14301, /* [0x0138] */
	0x00000004, /* [0x0139] */
	0x40E78683, /* [0x013A] */
	0xFCFCFCFC, /* [0x013B] */
	0xFCFCFCFC, /* [0x013C] */
	0xFCFCFCFC, /* [0x013D] */
	0x48E0A201, /* [0x013E] */
	0x00000000, /* [0x013F] */
	0x40E0A301, /* [0x0140] */
	0x00000004, /* [0x0141] */
	0x48E1B285, /* [0x0142] */
	0x00000001, /* [0x0143] */
	0x00004000, /* [0x0144] */
	0x00000000, /* [0x0145] */
	0x00000004, /* [0x0146] */
	0x000000C0, /* [0x0147] */
	0x48E09801, /* [0x0148] */
	0x00000001, /* [0x0149] */
	0x48E00401, /* [0x014A] */
	0x00000000, /* [0x014B] */
	0x480CDD02, /* [0x014C] */
	0x00200074, /* [0x014D] */
	0x00000000, /* [0x014E] */
	0x40E15285, /* [0x014F] */
	0x00000A30, /* [0x0150] */
	0x00000008, /* [0x0151] */
	0x00000100, /* [0x0152] */
	0x00000000, /* [0x0153] */
	0x00000000, /* [0x0154] */
	0x48E14101, /* [0x0155] */
	0x0000C008, /* [0x0156] */
	0x40E0A001, /* [0x0157] */
	0x00000008, /* [0x0158] */
	0x40E28001, /* [0x0159] */
	0x00010004, /* [0x015A] */
	0x40E38401, /* [0x015B] */
	0x00000404, /* [0x015C] */
	0x40E78501, /* [0x015D] */
	0x0000003F, /* [0x015E] */
	0x48E5D301, /* [0x015F] */
	0x00000030, /* [0x0160] */
	0x48E5CB01, /* [0x0161] */
	0x00000100, /* [0x0162] */
	0x40E5CA01, /* [0x0163] */
	0x001F9F81, /* [0x0164] */
	0x40E14601, /* [0x0165] */
	0x00000001, /* [0x0166] */
	0x40E38E01, /* [0x0167] */
	0x00000000, /* [0x0168] */
	0x40E28A01, /* [0x0169] */
	0x00000000, /* [0x016A] */
	0x48E1A901, /* [0x016B] */
	0xFFFF0100, /* [0x016C] */
	0x40E5C901, /* [0x016D] */
	0x00000100, /* [0x016E] */
	0x40E76401, /* [0x016F] */
	0x00000000, /* [0x0170] */
	0x48E09401, /* [0x0171] */
	0x00000000, /* [0x0172] */
	0x40E1B001, /* [0x0173] */
	0x00000000, /* [0x0174] */
	0x48E1B101, /* [0x0175] */
	0x00000006, /* [0x0176] */
	0x48E40001, /* [0x0177] */
	0x00000001, /* [0x0178] */
	0x48E40A04, /* [0x0179] */
	0x00000000, /* [0x017A] */
	0x00000000, /* [0x017B] */
	0x00000078, /* [0x017C] */
	0x00000008, /* [0x017D] */
	0x40E48A02, /* [0x017E] */
	0xC6700000, /* [0x017F] */
	0x00000001, /* [0x0180] */
	0x48E4CA01, /* [0x0181] */
	0x0000000F, /* [0x0182] */
	0x48E10001, /* [0x0183] */
	0x00000008, /* [0x0184] */
	0x48E0A101, /* [0x0185] */
	0x00000000, /* [0x0186] */
	0x40E10185, /* [0x0187] */
	0x00000000, /* [0x0188] */
	0x00000000, /* [0x0189] */
	0x00000001, /* [0x018A] */
	0x00000000, /* [0x018B] */
	0x00000000, /* [0x018C] */
	0x70230001, /* [0x018D] */
	0x00000000, /* [0x018E] */
	0x70388003, /* [0x018F] */
	0x00200984, /* [0x0190] */
	0x00000001, /* [0x0191] */
	0x00000003, /* [0x0192] */
	0x70380007, /* [0x0193] */
	0x00200504, /* [0x0194] */
	0x00000001, /* [0x0195] */
	0x00000003, /* [0x0196] */
	0x00000000, /* [0x0197] */
	0x00000000, /* [0x0198] */
	0x00000000, /* [0x0199] */
	0x00000006, /* [0x019A] */
	0x70460004, /* [0x019B] */
	0x00000004, /* [0x019C] */
	0x00000000, /* [0x019D] */
	0x00000000, /* [0x019E] */
	0x00000000, /* [0x019F] */
	0x70268000, /* [0x01A0] */
	0x70A88003, /* [0x01A1] */
	0x00200984, /* [0x01A2] */
	0x00000000, /* [0x01A3] */
	0x00000000, /* [0x01A4] */
	0x70460004, /* [0x01A5] */
	0x00000004, /* [0x01A6] */
	0x00000000, /* [0x01A7] */
	0x00000000, /* [0x01A8] */
	0x00000001, /* [0x01A9] */
	0x70268000, /* [0x01AA] */
	0x70298006, /* [0x01AB] */
	0x00200504, /* [0x01AC] */
	0x00000000, /* [0x01AD] */
	0x00000000, /* [0x01AE] */
	0x00000006, /* [0x01AF] */
	0x00000000, /* [0x01B0] */
	0x00000000, /* [0x01B1] */
	0x40E40801, /* [0x01B2] */
	0x0000000D, /* [0x01B3] */
	0x48E40901, /* [0x01B4] */
	0x00000000, /* [0x01B5] */
	0x70388003, /* [0x01B6] */
	0x00200984, /* [0x01B7] */
	0x00000001, /* [0x01B8] */
	0x00000003, /* [0x01B9] */
	0x00000000, /* [0x01BA] */
	0x00000000, /* [0x01BB] */
	0x00000000, /* [0x01BC] */
	0x00000000, /* [0x01BD] */
	0x00000000, /* [0x01BE] */
	0x00000000, /* [0x01BF] */
	0x70EA0001, /* [0x01C0] */
	0x00000000, /* [0x01C1] */
	0x40E78A01, /* [0x01C2] */
	0x000FFFFF, /* [0x01C3] */
	0x40E09001, /* [0x01C4] */
	0x00000000, /* [0x01C5] */
	0x40E00501, /* [0x01C6] */
	0x00000000, /* [0x01C7] */
	0x40E00001, /* [0x01C8] */
	0x00000181, /* [0x01C9] */
	0x48E10001, /* [0x01CA] */
	0x00000000, /* [0x01CB] */
	0x40E21385, /* [0x01CC] */
	0x00000004, /* [0x01CD] */
	0x00000000, /* [0x01CE] */
	0x00000000, /* [0x01CF] */
	0x00000001, /* [0x01D0] */
	0x00000001, /* [0x01D1] */
	0x40E21C01, /* [0x01D2] */
	0x00000000, /* [0x01D3] */
	0x40E21001, /* [0x01D4] */
	0x00000000, /* [0x01D5] */
	0x70460004, /* [0x01D6] */
	0x0000001E, /* [0x01D7] */
	0x00000000, /* [0x01D8] */
	0x00000000, /* [0x01D9] */
	0x00000001, /* [0x01DA] */
	0x00000000, /* [0x01DB] */
	0x00000000, /* [0x01DC] */
	0x00000000, /* [0x01DD] */
	0x00000000, /* [0x01DE] */
	0x00000000, /* [0x01DF] */
	0x40E78A01, /* [0x01E0] */
	0x020FFFFF, /* [0x01E1] */
	0x48E78B85, /* [0x01E2] */
	0x00000001, /* [0x01E3] */
	0x00003F05, /* [0x01E4] */
	0x00003F04, /* [0x01E5] */
	0x00003F04, /* [0x01E6] */
	0x00003F04, /* [0x01E7] */
	0x48E79001, /* [0x01E8] */
	0x00000000, /* [0x01E9] */
	0x40E79101, /* [0x01EA] */
	0x00000002, /* [0x01EB] */
	0x40E79201, /* [0x01EC] */
	0x00000002, /* [0x01ED] */
	0x40E58485, /* [0x01EE] */
	0x00000001, /* [0x01EF] */
	0x00003F05, /* [0x01F0] */
	0x00003F04, /* [0x01F1] */
	0x00003F04, /* [0x01F2] */
	0x00003F04, /* [0x01F3] */
	0x48E58901, /* [0x01F4] */
	0x00000000, /* [0x01F5] */
	0x48E7C302, /* [0x01F6] */
	0x00000002, /* [0x01F7] */
	0x00000001, /* [0x01F8] */
	0x48E7D702, /* [0x01F9] */
	0x00000002, /* [0x01FA] */
	0x00000001, /* [0x01FB] */
	0x40E7C802, /* [0x01FC] */
	0x00000000, /* [0x01FD] */
	0x00000000, /* [0x01FE] */
	0x40E7CD02, /* [0x01FF] */
	0x00000000, /* [0x0200] */
	0x00000000, /* [0x0201] */
	0x48E7D202, /* [0x0202] */
	0x00000000, /* [0x0203] */
	0x00000000, /* [0x0204] */
	0x40E7DC02, /* [0x0205] */
	0x00000000, /* [0x0206] */
	0x00000000, /* [0x0207] */
	0x48E38901, /* [0x0208] */
	0x00000000, /* [0x0209] */
	0x48E29A01, /* [0x020A] */
	0x00FFFF00, /* [0x020B] */
	0x48E00101, /* [0x020C] */
	0x00000000, /* [0x020D] */
	0x40E29D01, /* [0x020E] */
	0x0000FF00, /* [0x020F] */
	0x40E59001, /* [0x0210] */
	0x00000406, /* [0x0211] */
	0x48E59201, /* [0x0212] */
	0x00000001, /* [0x0213] */
	0x40E59301, /* [0x0214] */
	0x00000F00, /* [0x0215] */
	0x40E5A301, /* [0x0216] */
	0x00000000, /* [0x0217] */
	0x48E38501, /* [0x0218] */
	0x00000000, /* [0x0219] */
	0x00000000, /* [0x021A] */
	0x00000000, /* [0x021B] */
	0x00000000, /* [0x021C] */
	0x00000000, /* [0x021D] */
	0x00000000, /* [0x021E] */
	0x00000000, /* [0x021F] */
	0x48210001, /* [0x0220] */
	0x86000000, /* [0x0221] */
	0x40218001, /* [0x0222] */
	0x86000000, /* [0x0223] */
	0x40211089, /* [0x0224] */
	0x00001331, /* [0x0225] */
	0x00000000, /* [0x0226] */
	0x00000000, /* [0x0227] */
	0x00020001, /* [0x0228] */
	0x00000000, /* [0x0229] */
	0x00000000, /* [0x022A] */
	0x00000000, /* [0x022B] */
	0x00000000, /* [0x022C] */
	0x00000000, /* [0x022D] */
	0x48218201, /* [0x022E] */
	0x00001331, /* [0x022F] */
	0x40214383, /* [0x0230] */
	0x00000000, /* [0x0231] */
	0x00000000, /* [0x0232] */
	0x00000001, /* [0x0233] */
	0x40210789, /* [0x0234] */
	0x00000021, /* [0x0235] */
	0x00000000, /* [0x0236] */
	0x00000000, /* [0x0237] */
	0x00020001, /* [0x0238] */
	0x00000000, /* [0x0239] */
	0x00000000, /* [0x023A] */
	0x00000000, /* [0x023B] */
	0x00000000, /* [0x023C] */
	0x00000000, /* [0x023D] */
	0x48218101, /* [0x023E] */
	0x00000021, /* [0x023F] */
	0x48218401, /* [0x0240] */
	0x00000001, /* [0x0241] */
	0x702C8005, /* [0x0242] */
	0x00000002, /* [0x0243] */
	0x00000000, /* [0x0244] */
	0x00010001, /* [0x0245] */
	0x00000000, /* [0x0246] */
	0x00010001, /* [0x0247] */
	0x70B00023, /* [0x0248] */
	0x00600000, /* [0x0249] */
	0x00000000, /* [0x024A] */
	0x00000000, /* [0x024B] */
	0x00000000, /* [0x024C] */
	0x03000000, /* [0x024D] */
	0x00000000, /* [0x024E] */
	0x00000000, /* [0x024F] */
	0x00000000, /* [0x0250] */
	0x00000000, /* [0x0251] */
	0x00000000, /* [0x0252] */
	0x00000000, /* [0x0253] */
	0x00000000, /* [0x0254] */
	0x00000000, /* [0x0255] */
	0x00000000, /* [0x0256] */
	0x00000000, /* [0x0257] */
	0x00000000, /* [0x0258] */
	0x00000000, /* [0x0259] */
	0x00000000, /* [0x025A] */
	0x00000000, /* [0x025B] */
	0x00000000, /* [0x025C] */
	0x00000000, /* [0x025D] */
	0x00000000, /* [0x025E] */
	0x00000000, /* [0x025F] */
	0x00000000, /* [0x0260] */
	0x00000000, /* [0x0261] */
	0x00000000, /* [0x0262] */
	0x00000000, /* [0x0263] */
	0x00000000, /* [0x0264] */
	0x00000000, /* [0x0265] */
	0x00000000, /* [0x0266] */
	0x00000000, /* [0x0267] */
	0x00000000, /* [0x0268] */
	0x00000000, /* [0x0269] */
	0x00000000, /* [0x026A] */
	0x00000000, /* [0x026B] */
	0x40E09301, /* [0x026C] */
	0x00000000, /* [0x026D] */
	0x40E38D01, /* [0x026E] */
	0x00000000, /* [0x026F] */
	0x40E29801, /* [0x0270] */
	0x0000FFFF, /* [0x0271] */
	0x48E28201, /* [0x0272] */
	0xEAEAEAEA, /* [0x0273] */
	0x40E29404, /* [0x0274] */
	0xFFFFFFFF, /* [0x0275] */
	0xFFFFFFFF, /* [0x0276] */
	0xFFFFFFFF, /* [0x0277] */
	0xFFFFFFFF, /* [0x0278] */
	0x40E5DB01, /* [0x0279] */
	0x00000000, /* [0x027A] */
	0x48E14701, /* [0x027B] */
	0x0000000F, /* [0x027C] */
	0x70B00023, /* [0x027D] */
	0x00700000, /* [0x027E] */
	0x00000000, /* [0x027F] */
	0x00000000, /* [0x0280] */
	0x00003C00, /* [0x0281] */
	0x20400000, /* [0x0282] */
	0x00000000, /* [0x0283] */
	0x20400001, /* [0x0284] */
	0x00000000, /* [0x0285] */
	0x20400002, /* [0x0286] */
	0x00003C00, /* [0x0287] */
	0x20400003, /* [0x0288] */
	0x00000000, /* [0x0289] */
	0x03000000, /* [0x028A] */
	0x00000000, /* [0x028B] */
	0x00000000, /* [0x028C] */
	0x00000000, /* [0x028D] */
	0x00000000, /* [0x028E] */
	0x00000000, /* [0x028F] */
	0x00000000, /* [0x0290] */
	0x00000000, /* [0x0291] */
	0x00000000, /* [0x0292] */
	0x00000000, /* [0x0293] */
	0x00000000, /* [0x0294] */
	0x00000000, /* [0x0295] */
	0x00000000, /* [0x0296] */
	0x00000000, /* [0x0297] */
	0x00000000, /* [0x0298] */
	0x00000000, /* [0x0299] */
	0x00000000, /* [0x029A] */
	0x00000000, /* [0x029B] */
	0x00000000, /* [0x029C] */
	0x00000000, /* [0x029D] */
	0x00000000, /* [0x029E] */
	0x00000000, /* [0x029F] */
	0x00000000, /* [0x02A0] */
};

/* Fixups for the IBs in _a5xx_critical_pkts_mem03 */
static const struct adreno_critical_fixup critical_pkt_mem03_fixups[] = {
	{ 2, 3, 3, 0x0780 },
	{ 6, 7, 2, 0x0000 },
	{ 98, 99, 1, 0x0000 },
	{ 112, 113, 1, 0x0480 },
	{ 115, 116, 1, 0x0400 },
	{ 126, 127, 1, 0x0080 },
	{ 131, 132, 2, 0x0108 },
	{ 137, 138, 1, 0x00A0 },
	{ 141, 142, 2, 0x0108 },
	{ 147, 148, 1, 0x0080 },
	{ 150, 151, 1, 0x00C0 },
	{ 174, 175, 3, 0x0780 },
	{ 378, 379, 1, 0x0000 },
	{ 392, 393, 1, 0x0480 },
	{ 395, 396, 1, 0x0400 },
	{ 408, 409, 1, 0x0080 },
	{ 413, 414, 2, 0x0108 },
	{ 419, 420, 1, 0x00A0 },
	{ 423, 424, 2, 0x0108 },
	{ 429, 430, 1, 0x0080 },
	{ 432, 433, 1, 0x00C0 },
	{ 462, 463, 0, 0x0700 },
	{ 472, 473, 2, 0x0110 },
	{ 550, 551, 1, 0x0500 },
	{ 561, 562, 1, 0x0600 },
	{ 566, 567, 1, 0x0700 },
};
