#
# Copyright (C) 2020 Alpine Electronics Inc.
#
# Licensed under the Apache License, Version 2.0 (the 'License');
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an 'AS IS' BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

################################################################################
KP_DIR="$(pwd)/kernel_platform"
GKI_BUILD_CONFIG="build.config"
links_dir="$(dirname $(readlink -e "${BASH_SOURCE[0]}"))"
gki_dir="$(dirname ${links_dir})"

# cleaning up kernel_platform tree for Android"
function delete_android_mk_bp_in_kp ()
{
	find ${KP_DIR} \( -name Android.mk -o -name Android.bp \) \
	    -a -not -path ${KP_DIR}/common/Android.bp -a -not -path ${KP_DIR}/msm-kernel/Android.bp \
	    -delete
}

# showcheck_package_available_usage - check if required package is available
# @*: None
function check_package_available ()
{
	return;
}

function extract_prebuilt_archives ()
{
	local -r extract_cmd="vendor/alpine/kernel/alap-linux/scripts/prebuilt_kernel_setup.sh"

	local T=$(gettop)
	if [ -z "${T}" ]; then
		echo "Couldn't locate the top of the tree.  Try setting TOP."
		return;
	fi
	if [ -x ${T}/${extract_cmd} ]; then
		(${T}/${extract_cmd} extract $*)
	fi
}


# do_run_script - run script
# @*: None
function do_run_script ()
{
	delete_android_mk_bp_in_kp

	extract_prebuilt_archives
	cp -f device/qcom/msmnile-kernel/build.config ${KP_DIR}
}

## main routine
do_run_script
