#
# Copyright (C) 2020 Alpine Electronics Inc.
#
# Licensed under the Apache License, Version 2.0 (the 'License');
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an 'AS IS' BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

################################################################################
function unpack_gki_archives ()
{
	local -r extract_cmd="vendor/alpine/kernel/alap-linux/scripts/prebuilt_kernel_setup.sh"

	local T=$(gettop)
	if [ -z "${T}" ]; then
		echo "Couldn't locate the top of the tree.  Try setting TOP."
		return;
	fi
	if [ -x ${T}/${extract_cmd} ]; then
		(${T}/${extract_cmd} gki-unpack $*)
	fi
}

# do_run_script - run script
# @*: None
function do_run_script ()
{
	# Unpack GKI binaries
	unpack_gki_archives $*
	return
}

## main routine
do_run_script $*
